package org.openxri.admin.webpages.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Store;
import org.openxri.store.StoreStatistics;

public class Statistics extends BasePage {

	private static final Log log = LogFactory.getLog(Statistics.class);

	private static final long serialVersionUID = -5652615525071338625L;

	private Long authoritiesCount;
	private Long subsegmentsCount;

	public Statistics() {

		this.setTitle(this.getString("title"));
		this.setModel(new CompoundPropertyModel(this));

		Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

		// get information out of the store

		try {

			this.authoritiesCount = ((StoreStatistics) openXRIStore).getAuthorityCount();
			this.subsegmentsCount = ((StoreStatistics) openXRIStore).getSubSegmentCount();
		} catch (StoreException ex) {

			log.error(ex);
			this.error(this.getString("storefail") + ex.getLocalizedMessage());
		}

		// create and add components

		this.add(new Label("authoritiesCount"));
		this.add(new Label("subsegmentsCount"));
		this.add(new PageLink("backLink", Index.class));
	}

	public Long getAuthoritiesCount() {
		return (this.authoritiesCount);
	}

	public void setAuthoritiesCount(Long authoritiesCount) {
		this.authoritiesCount = authoritiesCount;
	}

	public Long getSubsegmentsCount() {
		return (this.subsegmentsCount);
	}

	public void setSubsegmentsCount(Long subsegmentsCount) {
		this.subsegmentsCount = subsegmentsCount;
	}
}
