package org.openxri.admin.webpages.urimapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.Model;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.config.ServerConfig;
import org.openxri.urimapper.URIMapper;
import org.openxri.urimapper.URIMapperRequest;
import org.openxri.urimapper.URIMapperResult;

public class Index extends BasePage {

	private static final Log log = LogFactory.getLog(Index.class);

	private static final long serialVersionUID = -597481320422867019L;

	private RequestForm requestForm;
	private RequestResultFragment requestResultFragment;
	private CompleteForm completeForm;
	private CompleteResultFragment completeResultFragment;

	public Index() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.requestForm = new RequestForm("requestForm");
		this.requestResultFragment = new RequestResultFragment("requestResultPanel", "requestResultFragment", this);
		this.requestResultFragment.setVisible(false);

		this.completeForm = new CompleteForm("completeForm");
		this.completeResultFragment = new CompleteResultFragment("completeResultPanel", "completeResultFragment", this);
		this.completeResultFragment.setVisible(false);

		this.add(this.requestForm);
		this.add(this.requestResultFragment);
		this.add(this.completeForm);
		this.add(this.completeResultFragment);
	}

	private class RequestForm extends Form {

		private static final long serialVersionUID = -1713315514251822937L;

		public RequestForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(new URIMapperRequest()));

			// create and add components

			this.add(new TextField("path"));
			this.add(new TextField("query"));
		}

		@Override
		protected void onSubmit() {

			URIMapper openXRIURIMapper = ((OpenXRIAdminApplication) Application.get()).getOpenXRIURIMapper();

			URIMapperRequest request;
			URIMapperResult result;

			try {

				request = (URIMapperRequest) this.getModelObject();
				result = openXRIURIMapper.parseRequest(request);
				if (result == null) throw new RuntimeException();
			} catch (Exception ex) {

				log.error(ex);
				Index.this.error(Index.this.getString("parsefail") + ex.getLocalizedMessage());
				Index.this.requestResultFragment.setVisible(false);
				return;
			}

			Index.this.requestResultFragment.setModelObject(result);
			Index.this.requestResultFragment.setVisible(true);
		}
	}

	private class RequestResultFragment extends Fragment {

		private static final long serialVersionUID = 6148514263284960328L;

		public RequestResultFragment(String id, String markupId, MarkupContainer markupContainer) {

			super(id, markupId, markupContainer);
			this.setModel(new CompoundPropertyModel(new URIMapperResult()));

			// create and add components

			this.add(new Label("namespace"));
			this.add(new Label("query"));
		}
	}

	private class CompleteForm extends Form {

		private static final long serialVersionUID = 3446856115406904404L;

		private String namespace;

		public CompleteForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));

			// create and add components

			this.add(new TextField("namespace").setLabel(new Model("Namespace")).setRequired(true));
		}

		public String getNamespace() {
			return (this.namespace);
		}
		public void setNamespace(String namespace) {
			this.namespace = namespace;
		}

		@Override
		protected void onSubmit() {

			ServerConfig serverConfig = ((OpenXRIAdminApplication) Application.get()).getOpenXRIServerConfig();
			URIMapper openXRIURIMapper = ((OpenXRIAdminApplication) Application.get()).getOpenXRIURIMapper();

			try {

				StringBuffer uri = new StringBuffer()
				.append("http://")
				.append(serverConfig.getHostName())
				.append(":")
				.append(serverConfig.getHostPort())
				.append(serverConfig.getServletPath());

				openXRIURIMapper.completeURI(uri, this.namespace);

				Index.this.completeResultFragment.setUri(uri.toString());
			} catch (Exception ex) {

				log.error(ex);
				this.error(this.getString("completefail") + ex.getLocalizedMessage());
				Index.this.completeResultFragment.setVisible(false);
				return;
			}

			Index.this.completeResultFragment.setVisible(true);
		}
	}

	private class CompleteResultFragment extends Fragment {

		private static final long serialVersionUID = 7134515354523051427L;

		private String uri;

		public CompleteResultFragment(String id, String markupId, MarkupContainer markupContainer) {

			super(id, markupId, markupContainer);
			this.setModel(new CompoundPropertyModel(this));

			// create and add components

			this.add(new Label("uri"));
		}

		public String getUri() {
			return (this.uri);
		}
		public void setUri(String uri) {
			this.uri = uri;
		}
	}
}
