package org.openxri.resolve;

import java.util.ArrayList;

import org.openxri.XRI;
import org.openxri.resolve.*;
import org.openxri.resolve.exception.*;
import org.openxri.xml.*;

public class SampleResolver {

	public SampleResolver() {
		super();
		// TODO Auto-generated constructor stub
	}




	public static Resolver setupResolver()
	{
		// instantiate a Resolver object
		Resolver resolver = new Resolver();

		// configure roots
		XRD eqRoot = createAuthRoot("http://equal.xri.net/", "https://equal.xri.net/");
		eqRoot.setCanonicalID(new CanonicalID("="));
		Status eqRootStatus = new Status(Status.SUCCESS);
		eqRootStatus.setCID(Status.CID_VERIFIED);
		eqRoot.setStatus(eqRootStatus);
		resolver.setAuthority("=", eqRoot);

		XRD atRoot = createAuthRoot("http://at.xri.net/", "https://at.xri.net/");
		atRoot.setCanonicalID(new CanonicalID("@"));
		Status atRootStatus = new Status(Status.SUCCESS);
		atRootStatus.setCID(Status.CID_VERIFIED);
		atRoot.setStatus(atRootStatus);
		resolver.setAuthority("@", atRoot);

		return resolver;
	}

	public static XRD createAuthRoot(String uri, String httpsUri)
	{
		// creates an XRD object that contains an authority resolution service endpoint with the given URI
		XRD xrd = new XRD();

		// construct an authority resolution service
		Service srv = new Service();
		srv.addType(Tags.SERVICE_AUTH_RES);

		TrustType tt = new TrustType(); // default trust type

		String authMediaType = Tags.CONTENT_TYPE_XRDS + ";" + tt.getParameterPair();
		srv.addMediaType(authMediaType, SEPElement.MATCH_ATTR_CONTENT, Boolean.FALSE);
		srv.addURI(uri);

		if (httpsUri != null) {
			tt.setParameterPair(true, false);
			authMediaType = Tags.CONTENT_TYPE_XRDS + ";" + tt.getParameterPair();
			srv.addMediaType(authMediaType, SEPElement.MATCH_ATTR_CONTENT, Boolean.FALSE);
			srv.addURI(httpsUri);
		}
		// add it to the XRD
		xrd.addService(srv);

		return xrd;
	}


	public static void main (String[] args)
	{
		Resolver resolver = setupResolver();
		ResolverFlags flags = new ResolverFlags();
		ResolverCache rc = new ResolverCache();
		//rc.setNewCache("xrires2", 100);
		resolver.setCache(rc);
		resolver.setNegativeCacheTTL(5); // 5 secs

		try {

			// get the XRDS document for =foo with default trust type (none), following Refs if needed
			XRDS xrds = resolver.resolveAuthToXRDS(new XRI("@freexri"), flags, new ResolverState());

			// should have a positive cache for @freexri, and a negative for @freexri*nowhere2bFound
			try {
				xrds = resolver.resolveAuthToXRDS(new XRI("@freexri*nowhere2bFound"), flags, new ResolverState());
			}
			catch (PartialResolutionException e) {}

			// should get cache HITs
			try {
				xrds = resolver.resolveAuthToXRDS(new XRI("@freexri*nowhere2bFound"), flags, new ResolverState());
			}
			catch (PartialResolutionException e) {}

			// let the negative cache expire
			try {
				Thread.sleep(5000);
			} catch (InterruptedException e1) {}

			try {
				// should get cache HIT for @freexri and MISS for @freexri*nowhere2bFound
				xrds = resolver.resolveAuthToXRDS(new XRI("@freexri*nowhere2bFound"), flags, new ResolverState());
			}
			catch (PartialResolutionException e) {}

			
			flags.setHttps(true);

			try {
				xrds = resolver.resolveAuthToXRDS(new XRI("@freexri*markus"), flags, new ResolverState());
			}
			catch (PartialResolutionException e) {}

			xrds = resolver.resolveAuthToXRDS(new XRI("@freexri*markus"), flags, new ResolverState());

			
			XRD xrd = xrds.getFinalXRD();

			CanonicalID cid = xrd.getCanonicalidAt(0);
			if (cid == null) {
				// no CID? raise error or throw exception here 
			}

			System.out.println("CID=" + cid.getValue());

			// resolution completed successfully if we did not catch an exception
			System.out.println("XRDS = " + xrds.toString());

			// select a service using a set of criteria 
			ArrayList uris = resolver.resolveSEPToURIList("=foo/bar", new TrustType(), "xri://+some-type", "some/media-type", true);
			for (int i = 0; i < uris.size(); i++) {
				System.out.println("Resolved URI[" + i + "] = " + uris.get(0).toString());
			}
		}
		catch (PartialResolutionException prex)
		{
			// get the partially resolved results
			XRDS errXRDS = prex.getPartialXRDS();
			XRD errXRD = errXRDS.getFinalXRD();
			Status stat = errXRD.getStatus();
			String statusCode = (stat == null) ? "unknown" : stat.getCode();

			// the resolution did not complete successfully
			System.err.println("Resolution error code: " + statusCode);
			System.err.println("Full error XRDS: " + errXRDS.toString());
		}
	}
}
