/*
 * Copyright 2005 OpenXRI Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/
package org.openxri.xml;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.openxri.saml.Assertion;
import org.openxri.saml.Attribute;
import org.openxri.saml.AttributeStatement;
import org.openxri.saml.NameID;
import org.openxri.saml.Subject;


/*
********************************************************************************
* Class: SignTest
********************************************************************************
*/ /**
* @author =chetan
*
* Tests signing and verifying the XRI Descriptor
*/
public class SignTest
    extends TestCase
{

      private static org.apache.commons.logging.Log log
		= org.apache.commons.logging.LogFactory.getLog(SignTest.class.getName());

    /*
    ****************************************************************************
    * main()
    ****************************************************************************
    */ /**
    *
    */
    public static void main(String[] args)
    {
        // Pass control to the non-graphical test runner
        TestRunner.run(suite());

    } // main()

    /*
    ****************************************************************************
    * suite()
    ****************************************************************************
    */ /**
    *
    */
    public static Test suite()
    {
        return new TestSuite(SignTest.class);

    } // suite()

    /*
    ****************************************************************************
    * testSignVerify()
    ****************************************************************************
    */ /**
    * Test sign/verify an XRD
    */
    public void testSignVerify()
    {
        try
        {
            KeyPairGenerator oKPG = KeyPairGenerator.getInstance("RSA");
            KeyPair oKP = oKPG.genKeyPair();

            XRD oXRID = new XRD();
            oXRID.genXmlID();
            Service authSrv = new Service();
            authSrv.addMediaType(Tags.CONTENT_TYPE_XRDS + ";trust=saml");
            authSrv.addType(Tags.SERVICE_AUTH_RES);
            authSrv.addURI("http://xri.epok.com");
            oXRID.addService(authSrv);

            String sParentID = "xyz";

            // create the SAMLSubject
            Subject oSubject = new Subject();
            NameID oName = new NameID(Tags.TAG_NAMEID);
            oName.setNameQualifier(sParentID);
            oName.setValue(".epok");
            oSubject.setNameID(oName);

            // create the SAML Attribute Statement
            AttributeStatement oAttrStatement = new AttributeStatement();
            Attribute oAttr = new Attribute();
            oAttr.setValue("#" + oXRID.getXmlID());
            oAttr.setName(Tags.TAG_XRD);
            oAttrStatement.setAttribute(oAttr);

            // now we can create the true SAML Assertion
            Assertion oAssertion = new Assertion();
            NameID oIssuer = new NameID(Tags.TAG_ISSUER);
            oIssuer.setValue("World's Best");
            oAssertion.setIssuer(oIssuer);
            oAssertion.setSubject(oSubject);
            oAssertion.setAttrStatement(oAttrStatement);
            oXRID.setSAMLAssertion(oAssertion);

            oXRID.sign(oKP.getPrivate());
            oXRID.setDOM(oXRID.getDOM());
            oXRID.verifySignature(oKP.getPublic());

            System.out.println("OLD XRD: " + oXRID.serializeDOM(false, true));

            XRD oNewXRID = XRD.parseXRD(oXRID.serializeDOM(false, true), true);

            String sNewXRID = oNewXRID.serializeDOM(false, true);
            System.out.println("NEW XRD: " + sNewXRID);

            oXRID.verifySignature(oKP.getPublic());
        }
        catch (Exception e)
        {
            e.printStackTrace();
            assertTrue(
                "Unexpected exception using XRD assertion", false);
        }

    } // testSignVerify()

} // Class: SignTest
