package org.openxri.config;

import java.io.Serializable;
import java.util.Properties;

/**
* Server components are pluggable parts of the OpenXRI server. They include:
* - Server
* - Store
* - URIMapper
* - Plugin
* 
* @author =peacekeeper
*/
public interface Component extends Serializable {

	/**
	 * A server component is constructed by the ComponentRegistry by passing a Properties object
	 * to its constructor and then calling this init() method.
	 */
	public void init() throws Exception;

	/**
	 * Returns the Properties object that was used to initialize the component.
	 * @return The stage's properties.
	 */
	public Properties getProperties();
}
