package org.openxri.config;

import java.util.List;

import org.openxri.pipeline.Pipeline;

/**
 * Provides a single point to obtain fully configured Pipeline instances.
 *
 * @author =peacekeeper
 */
public interface PipelineRegistry {

	public void init();
	
	public List<Pipeline> getPipelines();

	public Pipeline getPipelineByName(String name);
	
	public Pipeline getDefaultCreatePipeline();

	public Pipeline getDefaultLookupPipeline();
}
