package org.openxri.config;

import java.net.URISyntaxException;
import java.text.ParseException;

import org.openxri.proxy.impl.BasicProxy;
import org.openxri.xml.XRD;


/**
 * Provides an interface for retrieving the proxy preferences.
 *
 */
public interface ProxyConfig
{
	public static final String PROXY_CLASS = "proxy.class";
	public static final String DEFAULT_PROXY_CLASS = BasicProxy.class.getName();
	public static final String MAX_FOLLOW_REDIRECTS = "MaxFollowRedirects";
	public static final String MAX_FOLLOW_REFS = "MaxFollowRefs";
	public static final String MAX_REQUESTS = "MaxRequests";
	public static final String MAX_TOTAL_BYTES = "MaxTotalBytes";
	public static final String MAX_BYTES_PER_REQUEST = "MaxBytesPerRequest";
	public static final String AT_AUTHORITY = "AtAuthority";
	public static final String EQUALS_AUTHORITY = "EqualsAuthority";
	public static final String BANG_AUTHORITY = "BangAuthority";
	public static final String SUPPORTED_RES_MEDIA_TYPES = "SupportedResMediaTypes";
	public static final String HTTPS_BYPASS_AUTHORITIES = "HttpsBypassAuthorities";
	public static final String SAML_BYPASS_AUTHORITIES = "SamlBypassAuthorities";
	public static final String BARE_XRI_NOTFOUND_REDIRECT = "BareXRINotFoundRedirect";
	public static final String ROOT_REDIRECT = "RootRedirect";
	public static final String USE_CACHE = "UseCache";
	public static final String DEFAULT_CACHE_TTL = "DefaultCacheTTL";
	public static final String MIN_CACHE_TTL = "MinCacheTTL";
	public static final String MAX_CACHE_TTL = "MaxCacheTTL";
	public static final String NEGATIVE_CACHE_TTL = "NegativeCacheTTL";

	public static final String DEFAULT_MAX_FOLLOW_REDIRECTS = "10";
	public static final String DEFAULT_MAX_FOLLOW_REFS = "10";
	public static final String DEFAULT_MAX_REQUESTS = "10";
	public static final String DEFAULT_MAX_TOTAL_BYTES = "1048576";			// 1 MB
	public static final String DEFAULT_MAX_BYTES_PER_REQUEST = "512000";	// 500 KB
	public static final String DEFAULT_DEFAULT_CACHE_TTL = "1800"; // 30 minutes
	public static final String DEFAULT_MIN_CACHE_TTL = "0";
	public static final String DEFAULT_MAX_CACHE_TTL = "-1";
	public static final String DEFAULT_NEGATIVE_CACHE_TTL = "60"; // 1 minute

	/**
	 * Initializes configuration
	 */
	public void init() throws Exception;

	/**
	 * Persists any changes that were made to the configuration
	 */
	public void persist();

	/**
	 * For extensibility: Get any setting with a given key
	 */
	public String getSetting(String key);
	
	/**
	 * Returns the name of the Java class that implements the Server interface.
	 */
	public String getProxyImplClass();

	/**
	 * Sets the name of the Java class that implements the Server interface.
	 */

	public void setProxyImplClass(String sVal);

	/**
	 * If proxied resolution is enabled, this gets the = authority that this
	 * server can use its own proxy requests.
	 */
	public XRD getEqualsAuthority() throws URISyntaxException, ParseException;

	/**
	 * If proxied resolution is enabled, this sets the = authority that this
	 * server can use its own proxy requests.
	 */
	public void setEqualsAuthority(XRD oVal);

	/**
	 * If proxied resolution is enabled, this gets the @ authority that this
	 * server can use its own proxy requests.
	 */
	public XRD getAtAuthority() throws URISyntaxException, ParseException;

	/**
	 * If proxied resolution is enabled, this sets the @ authority that this
	 * server can use its own proxy requests.
	 */
	public void setAtAuthority(XRD oVal);

	/**
	 * If proxied resolution is enabled, this gets the = authority that this
	 * server can use its own proxy requests.
	 */
	public XRD getBangAuthority() throws URISyntaxException, ParseException;

	/**
	 * If proxied resolution is enabled, this sets the = authority that this
	 * server can use its own proxy requests.
	 */
	public void setBangAuthority(XRD oVal);

	public int getMaxBytesPerRequest();

	public void setMaxBytesPerRequest(int maxBytesPerRequest);

	public int getMaxFollowRedirects();

	public void setMaxFollowRedirects(int maxFollowRedirects);

	public int getMaxFollowRefs();

	public void setMaxFollowRefs(int maxFollowRefs);

	public int getMaxRequests();

	public void setMaxRequests(int maxRequests);

	public int getMaxTotalBytes();

	public void setMaxTotalBytes(int maxTotalBytes);

	public int getMaxHttpRedirectAllowed();

	public String[] getSupportedResMediaTypes();

	public void setSupportedResMediaTypes(String[] mediaTypes);
	
	public String[] getHttpsBypassAuthorities();
	
	public void setHttpsBypassAuthorities(String[] httpsBypassAuthorities);
	
	public String[] getSamlBypassAuthorities();
	
	public void setSamlBypassAuthorities(String[] samlBypassAuthorities);
	
	public String getBareXRINotFoundRedirect();
	
	public void setBareXRINotFoundRedirect(String bareXRINotFoundRedirect);
	
	public String getRootRedirect();

	public void setRootRedirect(String rootRedirect);

	public boolean getUseCache();
	
	public void setUseCache(boolean useCache);

	public int getDefaultCacheTTL();

	public void setDefaultCacheTTL(int defaultCacheTTL);
	
	public int getMinCacheTTL();

	public void setMinCacheTTL(int minCacheTTL);

	public int getMaxCacheTTL();
	
	public void setMaxCacheTTL(int maxCacheTTL);
	
	public int getNegativeCacheTTL();
	
	public void setNegativeCacheTTL(int negativeCacheTTL);

}
