package org.openxri.config;
import java.util.Properties;

/**
 * This class parses the XML configuration file and then contains all information from that file.
 * 
 * It also holds an instance of ComponentRegistry and PipelineRegistry, which are fully initialized
 * once the ServerConfig object is constructed.
 * 
 * @author =peacekeeper
 */
public interface ServerConfig {

	public void init() throws Exception;

	/**
	 * Gets the server-wide properties.
	 */
	public Properties getProperties();

	/**
	 * Gets the server's components.
	 */
	public ComponentRegistry getComponentRegistry();

	/**
	 * Gets the server's pipelines.
	 */
	public PipelineRegistry getPipelineRegistry();

	/**
	 * Gets the host name from the server-wide properties.
	 */
	public String getHostName();

	/**
	 * Gets the host port from the server-wide properties.
	 */
	public String getHostPort();

	/**
	 * Gets the servlet path from the server-wide properties.
	 */
	public String getServletPath();

	/**
	 * Gets the absolute path for a path relative to the web application.
	 * This just forwards the call to ServletContext.getRealPath();
	 */
	public String getRealPath(String relativePath);
}
