package org.openxri.pipeline;

import java.io.Serializable;
import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

/**
 * Stages are part of a pipeline and perform some specific task on an XRD. The returned XRD of one stage becomes
 * the input XRD of the next.
 * 
 * @author =peacekeeper
 */
public interface Stage extends Serializable {

	/**
	 * A stage is constructed by the PipelineRegistry by passing a Properties object
	 * to its constructor and then calling this init() method.
	 */
	public void init() throws Exception;

	/**
	 * Returns the Properties object that was used to initialize the stage.
	 * @return The stage's properties.
	 */
	public Properties getProperties();
	
	/**
	 * Called as part of executing a pipeline.
	 * @param store The store from which the authorities were retrieved.
	 * @param xrd A XRD as it currently looks like on the pipeline. The stage is free to modify and return it in any way.
	 * @param segment The XRI segment that resolves to the XRD being processed.
	 * @param parentAuthority The parent authority, i.e. the authority describing the XRD.
	 * @param subSegmentName The name of the subsegment that connects the two authorities.
	 * @param authority The authority, i.e. the authority described by the XRD.
	 * @param isCreate Whether this stage is execute as part of a CREATE pipeline.
	 * @return The XRD that is passed on to the next stage of the pipeline.
	 * @throws StageException
	 */
	public XRD execute(
			Store store,
			XRD xrd, 
			XRISegment segment,
			Authority parentAuthority, 
			String subSegmentName,
			Authority authority,
			boolean isCreate)
	throws StageException;
}
