package org.openxri.pipeline.stages;

import java.util.Date;
import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

/**
 * A stage that adds an <Expires> tag to the XRD with a relative expiration date.
 * 
 * Parameters for the stage's configuration:
 * 
 * seconds (optional, default: 7200): 
 * The relative expiration date (seconds from now) to be used to construct an <Expires> tag.
 * 
 * Recommended pipeline(s) for this stage: 
 * CREATE or LOOKUP
 * 
 * @author =peacekeeper
 */
public class AddExpiresRelativeStage extends AbstractStage {

	public static final String PROPERTIES_KEY_SECONDS = "seconds";

	public static final String DEFAULT_SECONDS = "7200";
	
	private Long seconds;

	public AddExpiresRelativeStage(Properties properties) {

		super(properties);
	}

	public void init() throws Exception {

		String seconds = this.properties.getProperty(PROPERTIES_KEY_SECONDS, DEFAULT_SECONDS);
		this.seconds = new Long(seconds);
	}

	public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {

		if (this.seconds == null) throw new StageException("Not initialized.");

		// add an <Expires> tag to the XRD

		xrd.setExpires(new Date(new Date().getTime() + this.seconds.longValue() * 1000));

		// done

		return(xrd);
	}
}
