package org.openxri.pipeline.stages;

import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;
import org.openxri.xml.XRD;

/**
 * A stage that adds a <ProviderID> element to the XRD and sets its value to the parent authority's <CanonicalID>.
 * 
 * Parameters for the stage's configuration:
 * (none)
 * 
 * Recommended pipeline(s) for this stage: 
 * LOOKUP
 * 
 * @author =peacekeeper
 */
public class AddProviderIDStage extends AbstractStage {

	public static final String ATTRIBUTES_KEY_LAST_CANONICALID = "last-canonicalid";

	public AddProviderIDStage(Properties properties) {

		super(properties);
	}

	public void init() throws Exception {

	}

	public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {

		if (! (store instanceof StoreAttributable)) throw new StageException("Cannot use this store implementation.");
		StoreAttributable storeAttributable = (StoreAttributable) store;

		// can only create a ProviderID if the parent authority has a CanonicalID

		if (parentAuthority == null) return(xrd);
		if (parentAuthority.getXrd().getNumCanonicalids() < 1) return(xrd);

		// create a new ProviderID from the parent authority's CanonicalID

		String providerID = parentAuthority.getXrd().getCanonicalidAt(0).getValue();

		// put the new ProviderID into the XRD

		xrd.setProviderID(providerID);

		// done

		return(xrd);
	}
}
