package org.openxri.pipeline.stages;

import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

/**
 * A stage that adds an <Query> tag to the XRD with the name of the current subsegment.
 * 
 * Parameters for the stage's configuration:
 * (none)
 * 
 * Recommended pipeline(s) for this stage: 
 * LOOKUP
 * 
 * @author =peacekeeper
 */
public class AddQueryStage extends AbstractStage {

	public AddQueryStage(Properties properties) {

		super(properties);
	}

	public void init() throws Exception {

	}

	public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {

		// add a <Query> tag to the XRD

		xrd.setQuery(subSegmentName);

		// done

		return(xrd);
	}
}
