package org.openxri.pipeline.stages;

import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.Status;
import org.openxri.xml.XRD;

/**
 * A stage that adds an <Status> tag to the XRD with a configurable code and text.
 * 
 * Parameters for the stage's configuration:
 * 
 * code (optional, default: "100"): 
 * The status code to add to the <Status> element
 * 
 * text (optional, default: "Success"): 
 * The status text to add to the <Status> element
 * 
 * Recommended pipeline(s) for this stage: 
 * LOOKUP
 * 
 * @author =peacekeeper
 */
public class AddStatusStage extends AbstractStage {

	public static final String PROPERTIES_KEY_CODE = "code";
	public static final String PROPERTIES_KEY_TEXT = "text";

	public static final String DEFAULT_CODE = "100";
	public static final String DEFAULT_TEXT = "Success";
	
	private String code;
	private String text;

	public AddStatusStage(Properties properties) {

		super(properties);
	}

	public void init() throws Exception {

		String code = this.properties.getProperty(PROPERTIES_KEY_CODE, DEFAULT_CODE);
		this.code = code;

		String text = this.properties.getProperty(PROPERTIES_KEY_TEXT, DEFAULT_TEXT);
		this.text = text;
	}

	public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {

		if (this.code == null || this.text == null) throw new StageException("Not initialized.");

		// add a <Status> tag to the XRD

		xrd.setStatus(new Status(this.code, this.text));

		// done

		return(xrd);
	}
}
