package org.openxri.pipeline.stages;

import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

/**
 * A stage that causes a small, random delay, but does not alter the XRD.
 * 
 * @author =peacekeeper
 */
public class DelayStage extends AbstractStage {

	public DelayStage(Properties properties) {

		super(properties);
	}

	public void init() throws Exception {

	}

	public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {

		// do a delay

		try {

			double millis = (Math.random() + 2) * 1000;
			Thread.sleep((long) millis);
		} catch (InterruptedException ex) {

			throw new StageException(ex);
		}

		// done

		return(xrd);
	}
}
