package org.openxri.pipeline.stages;

import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

/**
 * A stage that clears the whole XRD. A fresh empty XRD will be passed to the next stage.
 * 
 * Parameters for the stage's configuration:
 * (none)
 * 
 * Recommended pipeline(s) for this stage: 
 * CREATE, LOOKUP
 * 
 * @author =peacekeeper
 */
public class EmptyXRDStage extends AbstractStage {

	public EmptyXRDStage(Properties properties) {

		super(properties);
	}

	public void init() {

	}

	public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
		
		return(new XRD());
	}
}
