package org.openxri.pipeline.stages;

import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.factories.ServerConfigFactory;
import org.openxri.pipeline.Pipeline;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

/**
 * A stage that executes a whole other pipeline as a sub-process.
 * 
 * Parameters for the stage's configuration:
 * 
 * pipeline (required):
 * The name of the pipeline to execute.
 * 
 * Recommended pipeline(s) for this stage: 
 * CREATE, LOOKUP
 *
 * @author =peacekeeper
 */
public class ExecutePipelineStage extends AbstractStage {

	public static final String PROPERTIES_KEY_PIPELINE = "pipeline";

	private Pipeline pipeline;

	public ExecutePipelineStage(Properties properties) {

		super(properties);
	}

	public void init() throws StageException {

		String pipeline = this.properties.getProperty(PROPERTIES_KEY_PIPELINE);
		if (pipeline == null) throw new StageException("Required property " + PROPERTIES_KEY_PIPELINE + " not found.");
		this.pipeline = ServerConfigFactory.getSingleton().getPipelineRegistry().getPipelineByName(pipeline);
	}

	public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {

		xrd = this.pipeline.execute(store, xrd, segment, parentAuthority, subSegmentName, authority, isCreate);

		return(xrd);
	}
}
