package org.openxri.pipeline.stages;

import java.util.Properties;

import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

/**
 * A stage looks up the XRD for the current subsegment from the store, and replaces
 * the current XRD on the pipeline.
 * 
 * This is the recommended first stage on the default LOOOKUP stage.
 * 
 * If there is no matching subsegment/authority in the store, the stage returns NULL,
 * which causes the pipeline to return NULL too, ultimately causing the AbstractServer
 * to send a 222 error XRD.
 * 
 * Parameters for the stage's configuration:
 * (none)
 * 
 * Recommended pipeline(s) for this stage: 
 * LOOKUP
 * 
 * @author =peacekeeper
 */
public class FromStoreStage extends AbstractStage {

	public FromStoreStage(Properties properties) {

		super(properties);
	}

	public void init() throws Exception {

	}

	public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {

		// get the authority's XRD
		
		if (authority == null) return(null);

		XRD storeXrd = (XRD) authority.getXrd();
		if (storeXrd == null) return(null);
		
		// done

		return((XRD) storeXrd.clone());
	}
}
