package org.openxri.plugin;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.openxri.config.Component;

/**
 * Provides interface for extending the functionality of the server to respond
 * to non-XRI specified requests.  Provides access to Store object, non-XRI
 * requests, startup, and shutdown of server.
 * 
 * @author =chetan
 */
public interface Plugin extends Component {

	/**
	 * Process a request that is not an XRI lookup
	 * @return True, if the plugin successfully handled the request.
	 */
	public boolean processCustomRequest(
			HttpServletRequest oReq, 
			HttpServletResponse oResp)
	throws IOException;
} 
