package org.openxri.proxy.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.openxri.config.ProxyConfig;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.exception.PartialResolutionException;

public class BasicProxy extends AbstractProxy {

	public BasicProxy(ProxyConfig config) {

		super(config);
	}

	@Override
	public boolean onBeforeResolution(String qxri, HttpServletRequest request, HttpServletResponse response) {

		// false means the superclass will proceed normally

		return false;
	}

	@Override
	public boolean onResolutionSuccess(String qxri, ResolverState state, Object result, HttpServletRequest request, HttpServletResponse response) {

		// false means the superclass will proceed normally

		return false;
	}

	@Override
	public boolean onPartialResolutionSuccess(String qxri, HttpServletRequest request, HttpServletResponse response, int errorCode, String errorMessage, PartialResolutionException pre) {

		// false means the superclass will proceed normally

		return false;
	}
}
