package org.openxri.server;

import org.openxri.config.Component;
import org.openxri.exceptions.ServerException;
import org.openxri.xml.XRDS;

/**
 * Interface for server operations. A server's task is to get static information from a store,
 * add dynamic things like Expire and Query tags, and return a complete XRDS.
 *
 * @author =peacekeeper
 */
public interface Server extends Component {

	/**
	 * Obtains a self-describing XRDS for a root namespace. This is called if the URIMapper
	 * was able to only extract a namespace from the request, but no query.
	 * 
	 * @param namespace The root namespace.
	 * @param signed Whether or not a signed descriptor is requested.
	 * @return The completed XRDS ready to be sent to the client
	 */
	public XRDS lookupSelfDescribing(String namespace, boolean signed) throws ServerException;

	/**
	 * Obtains an XRDS for an XRI segment. This is called if the URIMapper was able to extract
	 * a namespace and a query from the request.
	 * 
	 * @param namespace The root namespace of the segment.
	 * @param query The segment to resolve.
	 * @param signed Whether or not a signed descriptor is requested.
	 * @return The completed XRDS ready to be sent to the client
	 */
	public XRDS lookupByNamespace(String namespace, String query, boolean signed) throws ServerException;

	/**
	 * Obtains an XRDS for a path. This is called if the URIMapper was not even able to extract
	 * a namespace from the request.
	 * 
	 * @param path The HTTP path of the request.
	 * @param signed Whether or not a signed descriptor is requested.
	 * @return The completed XRDS ready to be sent to the client
	 */
	public XRDS lookupByPath(String path, boolean signed) throws ServerException;
}
