package org.openxri.store;

import java.io.InputStream;
import java.io.OutputStream;

import org.openxri.exceptions.StoreException;

/**
 * Provides methods for backuping and restoring all store contents to/from streams.
 * @author =peacekeeper
 */
public interface StoreBackupable {

	/**
	 * Backups all store contents into a stream.
	 * @param stream Stream to write all data into.
	 */
	public void backupStore(OutputStream stream) throws StoreException;

	/**
	 * Restores all store contents from a stream.
	 * @param stream Stream to read all data from.
	 */
	public void restoreStore(InputStream stream) throws StoreException;
}
