package org.openxri.store;

import org.openxri.exceptions.StoreException;
import org.openxri.xml.XRD;

/**
 * Methods for reading and manipulating refs and services of an authority.
 * @author =peacekeeper
 */
public interface StoreEditable {

	/**
	 * Sets the XRD of an authority.
	 * @param authority The authority.
	 * @param xrd The XRD to set for the authority.
	 * @throws StoreException
	 */
	public void setXrd(
			Authority authority, 
			XRD xrd) 
	throws StoreException;
}
