package org.openxri.store;

import org.openxri.XRIAuthority;
import org.openxri.exceptions.StoreException;


 /**
 * @author =chetan
 * @author =peacekeeper
 */
public interface StoreLookup {

	/**
	 * Finds a root subsegment with a given name.
	 * @param namespace The namespace (root subsegment) to look for.
	 * @return The found root subsegment, or null if it could not be found.
	 */
	public SubSegment findRootSubSegment(
			String namespace)
	throws StoreException;

	/**
	 * Finds a subsegment with a given authority and name.
	 * @param authority The authority to look for.
	 * @param name The subsegment name to look for.
	 * @return The found subsegment, or null if it could not be found.
	 */
	public SubSegment findSubSegment(
			Authority authority,
			String name)
	throws StoreException;

	/**
	 * Returns the authority of this subsegment.
	 * @param subSegment subsegment
	 * @return The authority for this subsegment; null if this store has no authority for
	 * the subsegment
	 */
	public Authority getSubSegmentParentAuthority(
			SubSegment subSegment) 
	throws StoreException;

	/**
	 * Returns the authority of this subsegment.
	 * @param subSegment subsegment
	 * @return The authority for this subsegment; null if this store has no authority for
	 * the subsegment
	 */
	public Authority getSubSegmentAuthority(
			SubSegment subSegment) 
	throws StoreException;

	/**
	 * This method iterates through all subsegments of the given authority path and returns its
	 * final authority. This only works if all subsegments are part of this store and if the whole
	 * authority path is in one of its root namespaces.
	 * @param authorityPath The XRI authority path to resolve
	 * @return The matching authority or null
	 * @throws StoreException
	 */
	public Authority localLookup(
			XRIAuthority authorityPath) 
	throws StoreException;
}
