package org.openxri.store.impl;

import java.util.Date;

import org.openxri.store.Authority;
import org.openxri.xml.XRD;

public abstract class AbstractAuthority implements Authority {

	@Override
	public String toString() {

		XRD xrd = this.getXrd();
		
		return((xrd == null) ? "null" : xrd.toString());
	}

	@Override
	public boolean equals(Object object) {

		if (object == this) return(true);
		if (object == null || ! (object instanceof Authority)) return(false);

		Authority other = (Authority) object;

		Long id1 = this.getId();
		Long id2 = other.getId();
		
		if (id1 == null || id2 == null) return(false);
		
		return(id1.equals(id2));
	}

	@Override
	public int hashCode() {

		XRD xrd = this.getXrd();
		
		return((xrd == null) ? 0 : xrd.hashCode());
	}

	public int compareTo(Authority other) {

		if (other == this) return(0);
		if (other == null) return(0);

		XRD xrd1 = this.getXrd();
		XRD xrd2 = other.getXrd();

		if (xrd1 == null || xrd2 == null) return(0);

		// TODO: Maybe there's a more meaningful way of comparing authorities than comparing their <Expires> tags...
		
		Date expires1 = xrd1.getExpires();
		Date expires2 = xrd2.getExpires();
		
		if (expires1 == null || expires2 == null) return(0);

		return(expires1.compareTo(expires2));
	}
}
