package org.openxri.store.impl;

import org.openxri.store.SubSegment;

public abstract class AbstractSubSegment implements SubSegment {

	@Override
	public String toString() {

		String name = this.getName();

		return((name == null) ? "null" : name);
	}

	@Override
	public boolean equals(Object object) {

		if (object == this) return(true);
		if (object == null || ! (object instanceof SubSegment)) return(false);

		SubSegment other = (SubSegment) object;

		Long id1 = this.getId();
		Long id2 = other.getId();
		
		if (id1 == null || id2 == null) return(false);
		
		return(id1.equals(id2));
	}

	@Override
	public int hashCode() {

		String name = this.getName();

		return((name == null) ? 0 : name.hashCode());
	}

	public int compareTo(SubSegment other) {

		if (other == this) return(0);
		if (other == null) return(0);

		String name1 = this.getName();
		String name2 = other.getName();

		if (name1 == null || name2 == null) return(0);

		return(name1.compareTo(name2));
	}
}
