package org.openxri.store.impl.db;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.hibernate.Session;
import org.openxri.store.impl.AbstractAuthority;
import org.openxri.xml.XRD;

public class DbAuthority extends AbstractAuthority {

	private static final long serialVersionUID = -4955787059210404122L;

	private Long id;
	private Integer version;
	private XRD xrd;
	private Set<DbSubSegment> children;
	private Set<DbSubSegment> subSegments;
	private Map<String, String> attributes;
	private String indx;
	private String path;

	DbAuthority() {

	}

	public Long getId() {
		
		return (this.id);
	}

	void setId(Long id) {
		
		this.id = id;
	}

	Integer getVersion() {
		
		return (this.version);
	}

	void setVersion(Integer version) {
		
		this.version = version;
	}

	public XRD getXrd() {
		
		return(this.xrd);
	}

	void setXrd(XRD xrd) {
		
		this.xrd = xrd;
	}

	Set<DbSubSegment> getChildren() {
	
		return(this.children);
	}

	void setChildren(Set<DbSubSegment> children) {
		
		this.children = children;
	}

	Set<DbSubSegment> getSubSegments() {
		
		return(this.subSegments);
	}

	void setSubSegments(Set<DbSubSegment> subSegments) {
		
		this.subSegments = subSegments;
	}

	Map<String, String> getAttributes() {

		return (this.attributes);
	}

	void setAttributes(Map<String, String> attributes) {

		this.attributes = attributes;
	}

	String getIndx() {

		return(this.indx);
	}

	void setIndx(String indx) {

		this.indx = indx;
	}

	String getPath() {

		return(this.path);
	}

	void setPath(String path) {

		this.path = path;
	}

	@SuppressWarnings("unchecked")
	static List<DbAuthority> All(Session session) {

		List<DbAuthority> list = session.getNamedQuery(DbAuthority.class.getName() + ".All")
		.list();

		return(list);
	}
	
	@SuppressWarnings("unchecked")
	static List<DbAuthority> AllByIndx(Session session, String indx) {
		
		List<DbAuthority> list = session.getNamedQuery(DbAuthority.class.getName() + ".AllByIndx")
			.setString("indx", indx)
			.list();
		
		return(list);
	}
	
	@SuppressWarnings("unchecked")
	static List<DbAuthority> AllByPath(Session session, String path) {
		
		List<DbAuthority> list = session.getNamedQuery(DbAuthority.class.getName() + ".AllByPath")
			.setString("path", path)
			.list();
		
		return(list);
	}
	
	@SuppressWarnings("unchecked")
	static List<DbAuthority> ByAttributeValue(Session session, String key, String value) {
		
		List<DbAuthority> list = session.getNamedQuery(DbAuthority.class.getName() + ".ByAttributeValue")
			.setString("key", key)
			.setString("value", value)
			.list();
		
		return(list);
	}

	static int DeleteAll(Session session) {

		int number = session.getNamedQuery(DbAuthority.class.getName() + ".DeleteAll")
		.executeUpdate();

		return(number);
	}

	static Long Count(Session session) {

		Long result = (Long) session.getNamedQuery(DbAuthority.class.getName() + ".Count")
		.uniqueResult();

		return(result);
	}
}
