package org.openxri.store.impl.db;

import java.util.List;
import java.util.Map;

import org.hibernate.Session;
import org.openxri.store.impl.AbstractSubSegment;

public class DbSubSegment extends AbstractSubSegment {

	private static final long serialVersionUID = 1182883484848444321L;

	private Long id;
	private Integer version;
	private String name;
	private DbAuthority parent;
	private DbAuthority authority;
	private Map<String, String> attributes;
	private String indx;

	DbSubSegment() {

	}

	public Long getId() {

		return(this.id);
	}

	void setId(Long id) {

		this.id = id;
	}

	Integer getVersion() {
		
		return (this.version);
	}

	void setVersion(Integer version) {
		
		this.version = version;
	}

	public String getName() {
		
		return(this.name);
	}
	
	public void setName(String name) {
		
		this.name = name;
	}
	
	DbAuthority getParent() {

		return(this.parent);
	}

	void setParent(DbAuthority parent) {

		this.parent = parent;
	}

	DbAuthority getAuthority() {

		return(this.authority);
	}

	void setAuthority(DbAuthority authority) {

		this.authority = authority;
	}

	Map<String, String> getAttributes() {

		return(this.attributes);
	}

	void setAttributes(Map<String, String> attributes) {

		this.attributes = attributes;
	}

	String getIndx() {

		return(this.indx);
	}

	void setIndx(String indx) {

		this.indx = indx;
	}

	@SuppressWarnings("unchecked")
	static List<DbSubSegment> All(Session session) {

		List<DbSubSegment> list = session.getNamedQuery(DbSubSegment.class.getName() + ".All")
		.list();

		return(list);
	}

	@SuppressWarnings("unchecked")
	static List<DbSubSegment> AllRoot(Session session) {

		List<DbSubSegment> list = session.getNamedQuery(DbSubSegment.class.getName() + ".AllRoot")
		.list();

		return(list);
	}

	@SuppressWarnings("unchecked")
	static List<DbSubSegment> AllByParentAndAuthority(Session session, DbAuthority parent, DbAuthority authority) {

		List<DbSubSegment> list = session.getNamedQuery(DbSubSegment.class.getName() + ".AllByParentAndAuthority")
		.setEntity("parent", parent)
		.setEntity("authority", authority)
		.list();

		return(list);
	}
	
	@SuppressWarnings("unchecked")
	static List<DbSubSegment> AllByIndx(Session session, String indx) {
		
		List<DbSubSegment> list = session.getNamedQuery(DbSubSegment.class.getName() + ".AllByIndx")
			.setString("indx", indx)
			.list();
		
		return(list);
	}

	static DbSubSegment RootByName(Session session, String name) {

		DbSubSegment result = (DbSubSegment) session.getNamedQuery(DbSubSegment.class.getName() + ".RootByName")
		.setString("name", name)
		.uniqueResult();

		return(result);
	}

	static DbSubSegment ByParentAndName(Session session, DbAuthority parent, String name) {

		DbSubSegment result = (DbSubSegment) session.getNamedQuery(DbSubSegment.class.getName() + ".ByParentAndName")
		.setEntity("parent", parent)
		.setString("name", name)
		.uniqueResult();

		return(result);
	}

	static DbSubSegment ByAuthorityAndName(Session session, DbAuthority authority, String name) {

		DbSubSegment result = (DbSubSegment) session.getNamedQuery(DbSubSegment.class.getName() + ".ByAuthorityAndName")
		.setEntity("authority", authority)
		.setString("name", name)
		.uniqueResult();

		return(result);
	}

	@SuppressWarnings("unchecked")
	static List<DbSubSegment> ByParentAndAuthority(Session session, DbAuthority parent, DbAuthority authority) {

		List<DbSubSegment> list = (List<DbSubSegment>) session.getNamedQuery(DbSubSegment.class.getName() + ".ByParentAndAuthority")
		.setEntity("parent", parent)
		.setEntity("authority", authority)
		.list();

		return(list);
	}
	
	@SuppressWarnings("unchecked")
	static List<DbSubSegment> ByAttributeValue(Session session, String key, String value) {
		
		List<DbSubSegment> list = session.getNamedQuery(DbSubSegment.class.getName() + ".ByAttributeValue")
			.setString("key", key)
			.setString("value", value)
			.list();
		
		return(list);
	}

	static int DeleteAll(Session session) {

		int number = session.getNamedQuery(DbSubSegment.class.getName() + ".DeleteAll")
		.executeUpdate();

		return(number);
	}

	static Long Count(Session session) {

		Long result = (Long) session.getNamedQuery(DbSubSegment.class.getName() + ".Count")
		.uniqueResult();

		return(result);
	}
}
