package org.openxri.store.impl.n;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

import org.openxri.XRIAuthority;
import org.openxri.config.impl.AbstractComponent;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;
import org.openxri.store.StoreBackupable;
import org.openxri.store.StoreBetterLookup;
import org.openxri.store.StoreEditable;
import org.openxri.store.StoreLookup;
import org.openxri.store.StoreStatistics;
import org.openxri.store.SubSegment;
import org.openxri.xml.XRD;

/**
 * A store that implements all the store interfaces, but does not actually store or retrieve anything.
 * @author =peacekeeper
 */
public class NullStore 
extends AbstractComponent
implements
Store,
StoreLookup,
StoreBetterLookup,
StoreEditable,
StoreAttributable,
StoreStatistics,
StoreBackupable {

	public NullStore(Properties properties) {

		super(properties);
	}

	public void init() {

	}

	public SubSegment createRootSubSegment(String name, XRD xrd) throws StoreException {

		return(new NullSubSegment());
	}

	public void deleteAuthority(Authority authority) throws StoreException {

	}

	public void deleteRootSubSegment(String name) throws StoreException {

	}

	public SubSegment[] listRootSubSegments() throws StoreException {

		return(new NullSubSegment[0]);
	}

	public SubSegment registerSubsegment(Authority parent, String name, Authority authority) throws StoreException {

		return(new NullSubSegment());
	}

	public SubSegment registerSubsegment(Authority parent, String name, XRD xrd) throws StoreException {

		return(new NullSubSegment());
	}

	public void releaseSubSegment(SubSegment subSegment) throws StoreException {

	}

	public SubSegment findRootSubSegment(String namespace) throws StoreException {

		return(new NullSubSegment());
	}

	public SubSegment findSubSegment(Authority authority, String name) throws StoreException {

		return(new NullSubSegment());
	}

	public Authority getSubSegmentAuthority(SubSegment subSegment) throws StoreException {

		return(new NullAuthority());
	}

	public Authority getSubSegmentParentAuthority(SubSegment subSegment) throws StoreException {

		return(new NullAuthority());
	}

	public String[] getAuthorityQxris(Authority authority) throws StoreException {

		return(new String[0]);
	}

	public String[] getAuthorityQxris(Authority authority, boolean reassignable, boolean persistent) throws StoreException {

		return(new String[0]);
	}

	public Authority[] listAuthorities() throws StoreException {

		return(new Authority[0]);
	}

	public SubSegment[] getAuthoritySubSegments(Authority authority) throws StoreException {

		return(new SubSegment[0]);
	}

	public SubSegment[] getAuthorityChildSubSegments(Authority authority) throws StoreException {

		return(new SubSegment[0]);
	}
	public synchronized SubSegment[] getSynonymSubSegments(Authority parent, Authority authority) throws StoreException {

		return(new SubSegment[0]);
	}


	public SubSegment[] listSubSegments() throws StoreException {

		return(new SubSegment[0]);
	}

	public Long getAuthorityCount() throws StoreException {

		return(new Long(0L));
	}

	public Long getSubSegmentCount() throws StoreException {

		return(new Long(0L));
	}

	public Authority localLookup(XRIAuthority authorityPath) throws StoreException {

		return(new NullAuthority());
	}

	public void backupStore(OutputStream stream) throws StoreException {

	}

	public void restoreStore(InputStream stream) throws StoreException {

	}

	public Authority createAuthority(XRD xrd) throws StoreException {

		return(new NullAuthority());
	}

	public void setXrd(Authority authority, XRD xrd) throws StoreException {

	}

	public Map<String, String> getAuthorityAttributes(Authority authority) throws StoreException {

		return(null);
	}

	public Map<String, String> getStoreAttributes() throws StoreException {

		return(null);
	}

	public Map<String, String> getSubSegmentAttributes(SubSegment subSegment) throws StoreException {

		return(null);
	}

	public Authority[] listAuthoritiesByAttributes(Selector selector) throws StoreException {

		return(new Authority[0]);
	}

	public SubSegment[] listSubSegmentsByAttributes(Selector selector) throws StoreException {

		return(new SubSegment[0]);
	}

	public Authority[] listAuthoritiesByAttributeValue(String key, String value) throws StoreException {

		return(new Authority[0]);
	}

	public SubSegment[] listSubSegmentsByAttributeValue(String key, String value) throws StoreException {

		return(new SubSegment[0]);
	}

	public Authority[] listAuthoritiesByIndex(String indx) throws StoreException {

		return(new Authority[0]);
	}

	public SubSegment[] listSubSegmentsByIndex(String indx) throws StoreException {

		return(new SubSegment[0]);
	}

	public void setAuthorityAttributes(Authority authority, Map<String, String> attributes) throws StoreException {

	}

	public void setStoreAttributes(Map<String, String> attributes) throws StoreException {

	}

	public void setSubSegmentAttributes(SubSegment subSegment, Map<String, String> attributes) throws StoreException {

	}

	public String getAuthorityIndex(Authority authority) throws StoreException {

		return null;
	}

	public String getSubSegmentIndex(SubSegment subSegment)
	throws StoreException {

		return null;
	}

	public void setAuthorityIndex(Authority authority, String indx)
	throws StoreException {

	}

	public void setSubSegmentIndex(SubSegment subSegment, String indx)
	throws StoreException {

	}
}
