package org.openxri.urimapper;

import org.openxri.config.Component;

/**
 * Provides an interface for taking the HTTP Request and mapping it to a data
 * structure that describes the type of XRI resolution request it is.
 *
 * Designed to be overriden so that custom schemes can be used to
 * @author =chetan
 */
public interface URIMapper extends Component {

	/**
	 * Parses an incoming request (containing of path and query part of a URI)
	 * @param request The path and query of the HTTP request.
	 * @returns Object which describes the request to the server
	 */
	public URIMapperResult parseRequest(URIMapperRequest request);

	/**
	 * Appends the needed namespace to the provided URI for
	 * resolution to this server
	 */
	public void completeURI(StringBuffer uri, String namespace);
}
