package org.openxri.urimapper;

import java.io.Serializable;

import javax.servlet.http.HttpServletRequest;

/**
 * Contains the parameters from an HTTP request needed to perform a lookup operation. 
 * 
 * @author =peacekeeper
 */
public class URIMapperRequest implements Serializable {

	private static final long serialVersionUID = -2646800121056178441L;

	private String path;
	private String query;

	public URIMapperRequest() {
		
	}
	
	public URIMapperRequest(String path, String query) {

		this.path = path;
		this.query = query;
	}

	public URIMapperRequest(HttpServletRequest request) {

		String requestURI = request.getRequestURI();
		String contextPath = request.getContextPath();
		String servletPath = request.getServletPath();

		this.path = requestURI.substring(contextPath.length() + servletPath.length());
		this.query = request.getQueryString();
	}

	public String getPath() {

		return(this.path);
	}

	public void setPath(String path) {

		this.path = path;
	}

	public String getQuery() {

		return(this.query);
	}

	public void setQuery(String query) {

		this.query = query;
	}

	@Override
	public String toString() {

		return(this.path + this.query);
	}

	@Override
	public int hashCode() {

		int hashCode = 1;
		
		if (this.path != null) hashCode = (hashCode * 31) + this.path.hashCode();
		if (this.query != null) hashCode = (hashCode * 31) + this.query.hashCode();
		
		return(hashCode);
	}

	@Override
	public boolean equals(Object object) {

		if (object == this || ! (object instanceof URIMapperRequest)) return(true);
		if (object == null) return(false);

		URIMapperRequest other = (URIMapperRequest) object;

		return((this.path + this.query).equals(other.path + other.query));
	}
}