package org.openxri.urimapper;

import java.io.Serializable;

/**
 * Contains the input parameters for a server lookup operation.
 * 
 * @author =peacekeeper
 */
public class URIMapperResult implements Serializable {

	private static final long serialVersionUID = -3505324081160942084L;

	private String namespace;
	private String query;

	public URIMapperResult() {
		
	}
	
	public URIMapperResult(String namespace, String query) {

		this.namespace = namespace;
		this.query = query;
	}

	public String getNamespace() {

		return(this.namespace);
	}

	public void setNamespace(String namespace) {

		this.namespace = namespace;
	}

	public String getQuery() {

		return(this.query);
	}

	public void setQuery(String query) {

		this.query = query;
	}

	@Override
	public String toString() {

		return(this.namespace + this.query);
	}

	@Override
	public int hashCode() {

		int hashCode = 1;
		
		if (this.namespace != null) hashCode = (hashCode * 31) + this.namespace.hashCode();
		if (this.query != null) hashCode = (hashCode * 31) + this.query.hashCode();
		
		return(hashCode);
	}

	@Override
	public boolean equals(Object object) {

		if (object == this || ! (object instanceof URIMapperResult)) return(true);
		if (object == null) return(false);

		URIMapperResult other = (URIMapperResult) object;

		return((this.namespace + this.query).equals(other.namespace + other.query));
	}
}
