
package org.openxri.urimapper.impl;

import java.util.Properties;
import java.util.regex.Pattern;

/**
 * Implements the URIMapper interface, using a folder structure for URLs.
 * Does not use the query string if there is one.
 * If you use this mapper, your server will respond to URLs like this one:
 * 
 * http://yourdomain.com/ns/@free/*earth*moon
 * 
 * (Assuming @free has an authority resolution service endpoint pointing to your server)
 * 
 * @author =peacekeeper
 */
public class FolderURIMapper extends RegexURIMapper {

	public static final Pattern namespacePattern = Pattern.compile("^/ns/([^/]+)/.*$");
	public static final Pattern queryPattern = Pattern.compile("^/[^/]+/[^/]+/([^?]*)$");

	public FolderURIMapper(Properties properties) {

		super(properties, namespacePattern, queryPattern);
	}

	public void init() {

	}

	public void completeURI(StringBuffer uri, String namespace) {

		uri.append("ns/" + namespace);
		uri.append("/");
	}
}
