package org.openxri.urimapper.impl;

import java.util.Properties;

import org.openxri.config.impl.AbstractComponent;
import org.openxri.urimapper.URIMapper;
import org.openxri.urimapper.URIMapperRequest;
import org.openxri.urimapper.URIMapperResult;

/**
 * Implements the URIMapper interface based on a simple query-parameter based
 * scheme.  ns=??? is used to query within a namespace, id=??? is used to query
 * an authority id.
 * @author =chetan
 */
public class QueryURIMapper extends AbstractComponent implements URIMapper {

	public QueryURIMapper(Properties properties) {

		super(properties);
	}

	public void init() {

	}

	public URIMapperResult parseRequest(URIMapperRequest request) {

		String sPath = request.getPath();
		String sQuery = request.getQuery();
		if ((sQuery == null) || (sQuery.length() == 0))
		{
			return null;
		}

		URIMapperResult oRetval = new URIMapperResult();

		// Gather the resolve data
		if ((sPath != null) && (sPath.length() > 1) &&
				(sPath.charAt(0) == '/'))
		{
			// Trim the slash
			sPath = sPath.substring(1);
			oRetval.setQuery(sPath);
		}
		else
		{
			return null;
		}

		// Determine the type of real query we have
		String sLowQuery = sQuery.toLowerCase();
		if (sLowQuery.startsWith("namespace="))
		{
			oRetval.setNamespace(sQuery.substring(3));
		}
		else
		{
			// we have no idea what was being asked at 
			// this point
			return null;
		}

		return oRetval;

	}

	/**
	 * Appends the needed path or query fragment to the provided URI for
	 * resolution to this server
	 */
	public void completeURI(StringBuffer uri, String namespace) {

		uri.append("?namespace=" + namespace);
		uri.append("&query=");
	} 
}
