package org.openxri.urimapper.impl;

import java.util.Properties;
import java.util.regex.Pattern;

import org.openxri.urimapper.URIMapperRequest;
import org.openxri.urimapper.URIMapperResult;

/**
 * An URI mapper assuming a fixed namespace (root authority). Useful for a resolver whose
 * store handles only a single namespace. In that case it is not necessary to have it in the URI.
 * 
 * This URI mapper expects a parameter with key "namespace" in the server configuration.
 * 
 * @author =peacekeeper
 */
public class SingleNamespaceURIMapper extends RegexURIMapper {

	public static final String CONFIG_NAMESPACE_KEY = "namespace";

	public static final Pattern namespacePattern = Pattern.compile("^/ns/().*$");
	public static final Pattern queryPattern = Pattern.compile("^/.*/(.*)$");

	private String namespace;

	public SingleNamespaceURIMapper(Properties properties) {

		super(properties, namespacePattern, queryPattern);

		this.namespace = properties.getProperty(CONFIG_NAMESPACE_KEY);
	}

	public void init() {

	}

	public URIMapperResult parseRequest(URIMapperRequest request) {

		URIMapperResult uriData = super.parseRequest(request);

		if (uriData != null) uriData.setNamespace(this.namespace);	// override the (empty) result from the RegexURIMapper

		return(uriData);
	}

	public void completeURI(StringBuffer uri, String namespace) {

		uri.append("/");
	}

	public void setNamespace(String namespace) {

		this.namespace = namespace;
	}

	public String getNamespace() {

		return(this.namespace);
	}
}
