package org.openxri.urimapper.test;

import java.util.Properties;

import junit.framework.TestCase;

import org.openxri.urimapper.URIMapper;
import org.openxri.urimapper.URIMapperRequest;
import org.openxri.urimapper.URIMapperResult;
import org.openxri.urimapper.impl.FolderURIMapper;

public class FolderURIMapperTest extends TestCase {

	protected URIMapper mapper;

	public FolderURIMapperTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		super.setUp();

		Properties properties = new Properties();
		this.mapper = new FolderURIMapper(properties);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public final void testParseRequest() {

		URIMapperRequest request = new URIMapperRequest();
		request.setPath("/ns/@free/*markus");

		URIMapperResult result = this.mapper.parseRequest(request);
		assertEquals(result.getNamespace(), "@free");
		assertEquals(result.getQuery(), "*markus");
	}
}
