package org.openxri.urimapper.test;

import java.util.Properties;

import junit.framework.TestCase;

import org.openxri.urimapper.URIMapperRequest;
import org.openxri.urimapper.URIMapperResult;
import org.openxri.urimapper.impl.SingleNamespaceURIMapper;

public class SingleNamespaceURIMapperTest extends TestCase {

	protected SingleNamespaceURIMapper mapper;

	public SingleNamespaceURIMapperTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		super.setUp();

		Properties properties = new Properties();
		properties.setProperty("namespace", "=parity");
		this.mapper = new SingleNamespaceURIMapper(properties);

	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public final void testParseRequest() {

		URIMapperRequest request = new URIMapperRequest();
		request.setPath("/ns/*markus");

		URIMapperResult result = this.mapper.parseRequest(request);
		System.out.println(result.getNamespace());
		System.out.println(result.getQuery());
	}

}
