/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ops4j.pax.exam.ConfigurationFactory;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.spi.ExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactorFactory;
import org.ops4j.spi.ServiceProviderFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExamReactor
implements ExamReactor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExamReactor.class);
    private final List<Option[]> configurations;
    private final List<TestProbeBuilder> probes;
    private final TestContainerFactory testContainerFactory;
    private final ExamSystem system;

    public DefaultExamReactor(ExamSystem system, TestContainerFactory factory) {
        this.system = system;
        this.configurations = new ArrayList<Option[]>();
        this.probes = new ArrayList<TestProbeBuilder>();
        this.testContainerFactory = factory;
    }

    @Override
    public synchronized void addConfiguration(Option[] configuration) {
        this.configurations.add(configuration);
    }

    @Override
    public synchronized void addProbe(TestProbeBuilder builder) {
        this.probes.add(builder);
    }

    @Override
    public synchronized StagedExamReactor stage(StagedExamReactorFactory factory) {
        LOG.debug("Staging reactor with probes: " + this.probes.size() + " using strategy: " + factory);
        ArrayList<TestContainer> containers = new ArrayList<TestContainer>();
        if (this.configurations.isEmpty()) {
            List configurationFactories = ServiceProviderFinder.findServiceProviders(ConfigurationFactory.class);
            for (ConfigurationFactory cf : configurationFactories) {
                Option[] configuration = cf.createConfiguration();
                this.addConfiguration(configuration);
            }
        }
        if (this.configurations.isEmpty()) {
            LOG.debug("No configuration given. Setting an empty one.");
            this.configurations.add(CoreOptions.options((Option[])new Option[0]));
        }
        for (Option[] config : this.configurations) {
            containers.addAll(Arrays.asList(this.testContainerFactory.create(this.system.fork(config))));
        }
        return factory.create(containers, this.probes);
    }
}

