/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.options.AbstractProvisionOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenUrlReference;

public class MavenArtifactProvisionOption
extends AbstractProvisionOption<MavenArtifactProvisionOption>
implements MavenUrlReference {
    private final MavenUrlReference artifact;
    private boolean updateUsed;

    public MavenArtifactProvisionOption() {
        this.artifact = new MavenArtifactUrlReference();
    }

    public MavenArtifactProvisionOption(MavenUrlReference artifact) {
        NullArgumentException.validateNotNull((Object)artifact, (String)"Maven artifact");
        this.artifact = artifact;
    }

    @Override
    public MavenArtifactProvisionOption groupId(String groupId) {
        this.artifact.groupId(groupId);
        this.updateUsed = false;
        return this.itself();
    }

    @Override
    public MavenArtifactProvisionOption artifactId(String artifactId) {
        this.artifact.artifactId(artifactId);
        return this.itself();
    }

    @Override
    public MavenArtifactProvisionOption type(String type) {
        this.artifact.type(type);
        return this.itself();
    }

    @Override
    public MavenArtifactProvisionOption classifier(String classifier) {
        this.artifact.classifier(classifier);
        return this.itself();
    }

    @Override
    public MavenArtifactProvisionOption version(String version) {
        this.artifact.version(version);
        return this.itself();
    }

    @Override
    public MavenArtifactProvisionOption version(MavenUrlReference.VersionResolver resolver) {
        this.artifact.version(resolver);
        return this.itself();
    }

    @Override
    public MavenArtifactProvisionOption versionAsInProject() {
        this.artifact.versionAsInProject();
        return this.itself();
    }

    @Override
    public Boolean isSnapshot() {
        return this.artifact.isSnapshot();
    }

    @Override
    public String getURL() {
        return this.artifact.getURL();
    }

    @Override
    public MavenArtifactProvisionOption update(Boolean shouldUpdate) {
        this.updateUsed = true;
        return (MavenArtifactProvisionOption)super.update(shouldUpdate);
    }

    @Override
    public boolean shouldUpdate() {
        if (!this.updateUsed) {
            super.update(this.isSnapshot() != null && this.isSnapshot() != false);
        }
        return super.shouldUpdate();
    }

    public String toString() {
        return this.artifact.toString();
    }

    @Override
    protected MavenArtifactProvisionOption itself() {
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
        result = 31 * result + (this.updateUsed ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifactProvisionOption other = (MavenArtifactProvisionOption)obj;
        if (this.artifact == null ? other.artifact != null : !this.artifact.equals(other.artifact)) {
            return false;
        }
        return this.updateUsed == other.updateUsed;
    }
}

