/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ClassByteAware;
import com.uwyn.rife.continuations.ContinuationConfig;
import com.uwyn.rife.continuations.asm.AnnotationVisitor;
import com.uwyn.rife.continuations.asm.Attribute;
import com.uwyn.rife.continuations.asm.ClassReader;
import com.uwyn.rife.continuations.asm.ClassVisitor;
import com.uwyn.rife.continuations.asm.FieldVisitor;
import com.uwyn.rife.continuations.asm.MethodVisitor;

public class ContinuableDetectionClassVisitor
implements ClassVisitor {
    private final String CONTINUABLE_CLASS_INTERNAL_NAME = ContinuationConfig.getInstance().getContinuableClassInternalName().intern();
    private final String CONTINUABLE_INTERFACE_INTERNAL_NAME = ContinuationConfig.getInstance().getContinuableInterfaceInternalName().intern();
    private final String OBJECT_INTERNAL_NAME = "java/lang/Object".intern();
    private final String OBJECT_NAME = "java.lang.Object".intern();
    private ClassByteAware mClassLoader = null;
    private boolean mIsContinuable = false;
    private String mSuperName = null;

    public ContinuableDetectionClassVisitor(ClassByteAware classLoader) {
        this.mClassLoader = classLoader;
    }

    boolean isElement(boolean doAutoReload, byte[] bytes) throws ClassNotFoundException {
        ClassReader detection_reader = null;
        while (!this.mIsContinuable) {
            detection_reader = new ClassReader(bytes);
            try {
                detection_reader.accept(this, true);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (null == this.mSuperName || this.OBJECT_NAME == this.mSuperName) break;
            if (this.mIsContinuable) continue;
            bytes = this.mClassLoader.getClassBytes(this.mSuperName);
        }
        return this.mIsContinuable;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.CONTINUABLE_CLASS_INTERNAL_NAME == superName.intern()) {
            this.mIsContinuable = true;
        } else {
            for (int i = 0; i < interfaces.length; ++i) {
                String interface_name = interfaces[i];
                if (this.CONTINUABLE_INTERFACE_INTERNAL_NAME != interface_name.intern()) continue;
                this.mIsContinuable = true;
                break;
            }
            this.mSuperName = null == superName ? null : (this.OBJECT_INTERNAL_NAME == superName.intern() ? this.OBJECT_NAME : superName.replace('/', '.').intern());
        }
        throw new RuntimeException("handled visit");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public void visitSource(String source, String debug) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
    }
}

