/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ContinuationDebug;
import com.uwyn.rife.continuations.util.ObjectUtils;
import com.uwyn.rife.continuations.util.StringUtils;
import java.util.Arrays;

public class ContinuationStack {
    static final int NONE = 0;
    static final int INTEGER = 1;
    static final int LONG = 2;
    static final int FLOAT = 3;
    static final int DOUBLE = 4;
    static final int REFERENCE = 5;
    private int[] mPositionMapping = null;
    private int[] mTypeMapping = null;
    private int mStackHeight = 0;
    private int[] mIntStack = null;
    private long[] mLongStack = null;
    private float[] mFloatStack = null;
    private double[] mDoubleStack = null;
    private Object[] mReferenceStack = null;
    private int mIntTop = 0;
    private int mLongTop = 0;
    private int mDoubleTop = 0;
    private int mFloatTop = 0;
    private int mReferenceTop = 0;

    ContinuationStack() {
    }

    ContinuationStack initialize() {
        this.mIntStack = new int[10];
        this.mLongStack = new long[5];
        this.mFloatStack = new float[5];
        this.mDoubleStack = new double[5];
        this.mReferenceStack = new Object[5];
        this.mPositionMapping = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.mTypeMapping = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        return this;
    }

    public int getType(int index) {
        if (index <= this.mTypeMapping.length - 1) {
            return this.mTypeMapping[index];
        }
        return 0;
    }

    public int popInt() {
        return this.getInt(--this.mStackHeight);
    }

    public long popLong() {
        return this.getLong(--this.mStackHeight);
    }

    public float popFloat() {
        return this.getFloat(--this.mStackHeight);
    }

    public double popDouble() {
        return this.getDouble(--this.mStackHeight);
    }

    public Object popReference() {
        return this.getReference(--this.mStackHeight);
    }

    public int getInt(int index) {
        int position = this.mPositionMapping[index];
        if (-1 == position || position >= this.mIntStack.length) {
            return 0;
        }
        return this.mIntStack[position];
    }

    public long getLong(int index) {
        int position = this.mPositionMapping[index];
        if (-1 == position || position >= this.mLongStack.length) {
            return 0L;
        }
        return this.mLongStack[position];
    }

    public float getFloat(int index) {
        int position = this.mPositionMapping[index];
        if (-1 == position || position >= this.mFloatStack.length) {
            return 0.0f;
        }
        return this.mFloatStack[position];
    }

    public double getDouble(int index) {
        int position = this.mPositionMapping[index];
        if (-1 == position || position >= this.mDoubleStack.length) {
            return 0.0;
        }
        return this.mDoubleStack[position];
    }

    public Object getReference(int index) {
        int position = this.mPositionMapping[index];
        if (-1 == position || position >= this.mReferenceStack.length) {
            return null;
        }
        return this.mReferenceStack[position];
    }

    private void storeIndex(int index, int position, int type) {
        if (index > this.mPositionMapping.length - 1) {
            int size = ((index + 1) / 10 + 1) * 10;
            int[] new_positionmapping = new int[size];
            int[] new_typemapping = new int[size];
            Arrays.fill(new_positionmapping, this.mPositionMapping.length, new_positionmapping.length, -1);
            Arrays.fill(new_typemapping, this.mTypeMapping.length, new_typemapping.length, -1);
            System.arraycopy(this.mPositionMapping, 0, new_positionmapping, 0, this.mPositionMapping.length);
            System.arraycopy(this.mTypeMapping, 0, new_typemapping, 0, this.mTypeMapping.length);
            this.mPositionMapping = new_positionmapping;
            this.mTypeMapping = new_typemapping;
        }
        this.mPositionMapping[index] = position;
        this.mTypeMapping[index] = type;
    }

    public void incrementInt(int index, int increment) {
        int position = -1;
        int n = position = this.mPositionMapping[index];
        this.mIntStack[n] = this.mIntStack[n] + increment;
    }

    public void pushInt(int value) {
        this.storeInt(this.mStackHeight++, value);
    }

    public void pushLong(long value) {
        this.storeLong(this.mStackHeight++, value);
    }

    public void pushFloat(float value) {
        this.storeFloat(this.mStackHeight++, value);
    }

    public void pushDouble(double value) {
        this.storeDouble(this.mStackHeight++, value);
    }

    public void pushReference(Object value) {
        this.storeReference(this.mStackHeight++, value);
    }

    public void storeInt(int index, int value) {
        int position = -1;
        if (this.getType(index) != 1) {
            position = this.mIntTop++;
            this.storeIndex(index, position, 1);
            if (position > this.mIntStack.length - 1) {
                int size = ((position + 1) / 10 + 1) * 10;
                int[] new_stack = new int[size];
                System.arraycopy(this.mIntStack, 0, new_stack, 0, this.mIntStack.length);
                this.mIntStack = new_stack;
            }
        } else {
            position = this.mPositionMapping[index];
        }
        this.mIntStack[position] = value;
    }

    public void storeLong(int index, long value) {
        int position = -1;
        if (this.getType(index) != 2) {
            position = this.mLongTop++;
            this.storeIndex(index, position, 2);
            if (position > this.mLongStack.length - 1) {
                int size = ((position + 1) / 10 + 1) * 10;
                long[] new_stack = new long[size];
                System.arraycopy(this.mLongStack, 0, new_stack, 0, this.mLongStack.length);
                this.mLongStack = new_stack;
            }
        } else {
            position = this.mPositionMapping[index];
        }
        this.mLongStack[position] = value;
    }

    public void storeFloat(int index, float value) {
        int position = -1;
        if (this.getType(index) != 3) {
            position = this.mFloatTop++;
            this.storeIndex(index, position, 3);
            if (position > this.mFloatStack.length - 1) {
                int size = ((position + 1) / 10 + 1) * 10;
                float[] new_stack = new float[size];
                System.arraycopy(this.mFloatStack, 0, new_stack, 0, this.mFloatStack.length);
                this.mFloatStack = new_stack;
            }
        } else {
            position = this.mPositionMapping[index];
        }
        this.mFloatStack[position] = value;
    }

    public void storeDouble(int index, double value) {
        int position = -1;
        if (this.getType(index) != 4) {
            position = this.mDoubleTop++;
            this.storeIndex(index, position, 4);
            if (position > this.mDoubleStack.length - 1) {
                int size = ((position + 1) / 10 + 1) * 10;
                double[] new_stack = new double[size];
                System.arraycopy(this.mDoubleStack, 0, new_stack, 0, this.mDoubleStack.length);
                this.mDoubleStack = new_stack;
            }
        } else {
            position = this.mPositionMapping[index];
        }
        this.mDoubleStack[position] = value;
    }

    public void storeReference(int index, Object value) {
        int position = -1;
        if (this.getType(index) != 5) {
            position = this.mReferenceTop++;
            this.storeIndex(index, position, 5);
            if (position > this.mReferenceStack.length - 1) {
                int size = ((position + 1) / 10 + 1) * 10;
                Object[] new_stack = new Object[size];
                System.arraycopy(this.mReferenceStack, 0, new_stack, 0, this.mReferenceStack.length);
                this.mReferenceStack = new_stack;
            }
        } else {
            position = this.mPositionMapping[index];
        }
        this.mReferenceStack[position] = value;
    }

    public void outputState() {
        ContinuationDebug.LOGGER.finest("");
        ContinuationDebug.LOGGER.finest("STACK : " + this);
        ContinuationDebug.LOGGER.finest("mPositionMapping[" + this.mPositionMapping.length + "] = " + StringUtils.join(this.mPositionMapping, ","));
        ContinuationDebug.LOGGER.finest("mTypeMapping[" + this.mTypeMapping.length + "]      = " + StringUtils.join(this.mTypeMapping, ","));
        ContinuationDebug.LOGGER.finest("mIntStack[" + this.mIntStack.length + "]      = " + StringUtils.join(this.mIntStack, ","));
        ContinuationDebug.LOGGER.finest("mLongStack[" + this.mLongStack.length + "]      = " + StringUtils.join(this.mLongStack, ","));
        ContinuationDebug.LOGGER.finest("mFloatStack[" + this.mFloatStack.length + "]     = " + StringUtils.join(this.mFloatStack, ","));
        ContinuationDebug.LOGGER.finest("mDoubleStack[" + this.mDoubleStack.length + "]    = " + StringUtils.join(this.mDoubleStack, ","));
        ContinuationDebug.LOGGER.finest("mReferenceStack[" + this.mReferenceStack.length + "] = " + StringUtils.join(this.mReferenceStack, ","));
    }

    public ContinuationStack clone(Object elementInstance) throws CloneNotSupportedException {
        ContinuationStack new_stack = new ContinuationStack();
        new_stack.mPositionMapping = (int[])this.mPositionMapping.clone();
        new_stack.mTypeMapping = (int[])this.mTypeMapping.clone();
        new_stack.mStackHeight = this.mStackHeight;
        new_stack.mIntStack = (int[])this.mIntStack.clone();
        new_stack.mLongStack = (long[])this.mLongStack.clone();
        new_stack.mFloatStack = (float[])this.mFloatStack.clone();
        new_stack.mDoubleStack = (double[])this.mDoubleStack.clone();
        new_stack.mReferenceStack = new Object[this.mReferenceStack.length];
        for (int i = 0; i < this.mReferenceStack.length; ++i) {
            new_stack.mReferenceStack[i] = this.mReferenceStack[i] != null && this.mReferenceStack[i].getClass() == elementInstance.getClass() ? elementInstance : ObjectUtils.deepClone(this.mReferenceStack[i]);
        }
        new_stack.mIntTop = this.mIntTop;
        new_stack.mLongTop = this.mLongTop;
        new_stack.mDoubleTop = this.mDoubleTop;
        new_stack.mFloatTop = this.mFloatTop;
        new_stack.mReferenceTop = this.mReferenceTop;
        return new_stack;
    }
}

