/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PFunction;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.POperator;
import org.lsmp.djep.sjep.PVariable;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.xjep.DoNothingVisitor;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XOperator;
import org.lsmp.djep.xjep.XVariable;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Divide;
import org.nfunk.jep.function.Multiply;
import org.nfunk.jep.function.Power;
import org.nfunk.jep.function.Subtract;
import org.nfunk.jep.function.UMinus;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NumberFactory;

public class PolynomialCreator
extends DoNothingVisitor {
    private XJep jep;
    Object zero;
    Object one;
    Object minusOne;
    Object infinity;
    Object nan;
    Object two;
    PConstant zeroConstant;
    PConstant oneConstant;
    PConstant minusOneConstant;
    PConstant infConstant;
    PConstant nanConstant;
    PConstant twoConstant;
    Monomial zeroMonomial;
    Monomial unitMonomial;
    Monomial infMonomial;
    Monomial nanMonomial;
    Polynomial zeroPolynomial;
    Polynomial unitPolynomial;
    Polynomial infPolynomial;
    Polynomial nanPolynomial;
    NumberFactory numf;
    OperatorSet os;
    NodeFactory nf;

    private PolynomialCreator() {
    }

    public PolynomialCreator(XJep j) {
        this.jep = j;
        this.numf = j.getNumberFactory();
        this.os = j.getOperatorSet();
        this.nf = j.getNodeFactory();
        this.zero = j.getNumberFactory().getZero();
        this.one = j.getNumberFactory().getOne();
        this.minusOne = j.getNumberFactory().getMinusOne();
        this.two = j.getNumberFactory().getTwo();
        try {
            this.infinity = this.div(this.one, this.zero);
            this.nan = this.div(this.zero, this.zero);
        }
        catch (ParseException e) {
            this.infinity = new Double(Double.POSITIVE_INFINITY);
            this.nan = new Double(Double.NaN);
        }
        this.zeroConstant = new PConstant(this, this.zero);
        this.oneConstant = new PConstant(this, this.one);
        this.twoConstant = new PConstant(this, this.two);
        this.minusOneConstant = new PConstant(this, this.minusOne);
        this.infConstant = new PConstant(this, this.infinity);
        this.nanConstant = new PConstant(this, this.nan);
    }

    public PNodeI createPoly(Node node) throws ParseException {
        return (PNodeI)node.jjtAccept(this, null);
    }

    public Node simplify(Node node) throws ParseException {
        PNodeI poly = this.createPoly(node);
        return poly.toNode();
    }

    public Node expand(Node node) throws ParseException {
        PNodeI poly = this.createPoly(node);
        PNodeI expand = poly.expand();
        return expand.toNode();
    }

    public int compare(Node node1, Node node2) throws ParseException {
        PNodeI poly1 = this.createPoly(node1);
        PNodeI exp1 = poly1.expand();
        PNodeI poly2 = this.createPoly(node2);
        PNodeI exp2 = poly2.expand();
        return exp1.compareTo(exp2);
    }

    public boolean equals(Node node1, Node node2) throws ParseException {
        PNodeI poly1 = this.createPoly(node1);
        PNodeI exp1 = poly1.expand();
        PNodeI poly2 = this.createPoly(node2);
        PNodeI exp2 = poly2.expand();
        return exp1.equals(exp2);
    }

    @Override
    public Object visit(ASTConstant node, Object data) throws ParseException {
        return new PConstant(this, node.getValue());
    }

    @Override
    public Object visit(ASTVarNode node, Object data) throws ParseException {
        return new PVariable(this, (XVariable)node.getVar());
    }

    @Override
    public Object visit(ASTFunNode node, Object data) throws ParseException {
        int nChild = node.jjtGetNumChildren();
        PNodeI[] args = new PNodeI[nChild];
        for (int i = 0; i < nChild; ++i) {
            args[i] = (PNodeI)node.jjtGetChild(i).jjtAccept(this, data);
        }
        XOperator op = (XOperator)node.getOperator();
        if (op == this.os.getAdd()) {
            PNodeI res = args[0];
            for (int i = 1; i < nChild; ++i) {
                res = res.add(args[i]);
            }
            return res;
        }
        if (op == this.os.getSubtract()) {
            if (args.length != 2) {
                throw new ParseException("Subtract must have two args it has " + args.length);
            }
            return args[0].sub(args[1]);
        }
        if (op == this.os.getUMinus()) {
            PNodeI res = args[0];
            return res.negate();
        }
        if (op == this.os.getMultiply()) {
            PNodeI res = args[0];
            for (int i = 1; i < nChild; ++i) {
                res = res.mul(args[i]);
            }
            return res;
        }
        if (op == this.os.getDivide()) {
            if (args.length != 2) {
                throw new ParseException("Divide must have two args it has " + args.length);
            }
            return args[0].div(args[1]);
        }
        if (op == this.os.getPower()) {
            if (args.length != 2) {
                throw new ParseException("Power must have two args it has " + args.length);
            }
            return args[0].pow(args[1]);
        }
        boolean allConst = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof PConstant) continue;
            allConst = false;
            break;
        }
        if (allConst) {
            Object val;
            Node[] newNodes = new Node[args.length];
            for (int i = 0; i < args.length; ++i) {
                newNodes[i] = args[i].toNode();
            }
            ASTFunNode topNode = op != null ? this.nf.buildOperatorNode((Operator)op, newNodes) : this.nf.buildFunctionNode(node.getName(), node.getPFMC(), newNodes);
            try {
                val = this.jep.evaluate(topNode);
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage());
            }
            return new PConstant(this, val);
        }
        if (op != null) {
            return new POperator(this, op, args);
        }
        return new PFunction(this, node.getName(), node.getPFMC(), args);
    }

    Object add(Object a, Object b) throws ParseException {
        return ((Add)this.os.getAdd().getPFMC()).add(a, b);
    }

    Object sub(Object a, Object b) throws ParseException {
        return ((Subtract)this.os.getSubtract().getPFMC()).sub(a, b);
    }

    Object mul(Object a, Object b) throws ParseException {
        return ((Multiply)this.os.getMultiply().getPFMC()).mul(a, b);
    }

    Object div(Object a, Object b) throws ParseException {
        return ((Divide)this.os.getDivide().getPFMC()).div(a, b);
    }

    Object intToValue(int i) {
        return new Double(i);
    }

    Object raise(Object a, Object b) throws ParseException {
        return ((Power)this.os.getPower().getPFMC()).power(a, b);
    }

    Object neg(Object val) throws ParseException {
        return ((UMinus)this.os.getUMinus().getPFMC()).umin(val);
    }

    int cmp(Object a, Object b) throws ParseException {
        if (a.equals(b)) {
            return 0;
        }
        if (a instanceof Complex) {
            Complex ca = (Complex)a;
            double ax = ca.re();
            double ay = ca.im();
            if (b instanceof Complex) {
                Complex cb = (Complex)b;
                double bx = cb.re();
                double by = cb.im();
                if (ax == bx) {
                    if (ay == by) {
                        return 0;
                    }
                    if (ay < by) {
                        return -1;
                    }
                    return 0;
                }
                if (ax < bx) {
                    return -1;
                }
                return 1;
            }
            if (b instanceof Number) {
                double bx = ((Number)b).doubleValue();
                double by = 0.0;
                if (ax == bx) {
                    if (ay == by) {
                        return 0;
                    }
                    if (ay < by) {
                        return -1;
                    }
                    return 0;
                }
                if (ax < bx) {
                    return -1;
                }
                return 1;
            }
            throw new ParseException("Don't know how to compare a Complex with " + b + " (" + b.getClass().getName() + ")");
        }
        if (a instanceof Number && b instanceof Complex) {
            double ax = ((Number)a).doubleValue();
            double ay = 0.0;
            Complex cb = (Complex)b;
            double bx = cb.re();
            double by = cb.im();
            if (ax == bx) {
                if (ay == by) {
                    return 0;
                }
                if (ay < by) {
                    return -1;
                }
                return 0;
            }
            if (ax < bx) {
                return -1;
            }
            return 1;
        }
        if (a instanceof Comparable && a.getClass().equals(b.getClass())) {
            return ((Comparable)a).compareTo(b);
        }
        if (a instanceof Number && b instanceof Number) {
            double bx;
            double ax = ((Number)a).doubleValue();
            if (ax == (bx = ((Number)b).doubleValue())) {
                return 0;
            }
            if (ax < bx) {
                return -1;
            }
            return 1;
        }
        if (a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        throw new IllegalArgumentException("Sorry don't know how to compare " + a + " (" + a.getClass().getName() + ") and " + b + " (" + b.getClass().getName() + ")");
    }
}

