/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.nfunk.jep.JEP;

class Console {
    private String prompt = "JEP > ";
    private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] args) throws IOException {
        Console c = new Console();
        c.run(args);
    }

    public void run(String[] args) throws IOException {
        String command = "";
        JEP j = new JEP();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        if (args.length > 0) {
            String temp = args[0];
            for (int i = 1; i < args.length; ++i) {
                temp = temp + " " + args[i];
            }
            j.parseExpression(temp);
            if (j.hasError()) {
                System.out.println(j.getErrorInfo());
            } else {
                System.out.println(j.getValueAsObject());
            }
        } else {
            System.out.println("JEP - Enter q to quit");
            System.out.print(this.prompt);
            while ((command = this.getCommand()) != null) {
                j.parseExpression(command);
                if (j.hasError()) {
                    System.out.println(j.getErrorInfo());
                } else {
                    Object value = j.getValueAsObject();
                    if (j.hasError()) {
                        System.out.println(j.getErrorInfo());
                    } else {
                        System.out.println(value);
                    }
                }
                System.out.print(this.prompt);
            }
        }
    }

    private String getCommand() throws IOException {
        if (this.br == null) {
            return null;
        }
        String s = this.br.readLine();
        if (s == null) {
            return null;
        }
        if (s.equals("q") || s.equals("quit") || s.equals("exit")) {
            return null;
        }
        return s;
    }
}

