/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitTimeouts;
import org.openqa.selenium.htmlunit.HtmlUnitWindow;
import org.openqa.selenium.htmlunit.logging.HtmlUnitLogs;
import org.openqa.selenium.logging.Logs;

public class HtmlUnitOptions
implements WebDriver.Options {
    private final HtmlUnitLogs logs;
    private final HtmlUnitDriver driver;
    private final HtmlUnitTimeouts timeouts;
    private final HtmlUnitWindow window;
    private final Function<? super com.gargoylesoftware.htmlunit.util.Cookie, @Nullable Cookie> htmlUnitCookieToSeleniumCookieTransformer = c -> new Cookie.Builder(c.getName(), c.getValue()).domain(c.getDomain()).path(c.getPath()).expiresOn(c.getExpires()).isSecure(c.isSecure()).isHttpOnly(c.isHttpOnly()).build();

    public HtmlUnitOptions(HtmlUnitDriver driver) {
        this.driver = driver;
        this.logs = new HtmlUnitLogs(this.getWebClient());
        this.timeouts = new HtmlUnitTimeouts(this.getWebClient());
        this.window = driver.getWindowManager();
    }

    public Logs logs() {
        return this.logs;
    }

    public void addCookie(Cookie cookie) {
        Page page = this.window.lastPage();
        if (!(page instanceof HtmlPage)) {
            throw new UnableToSetCookieException("You may not set cookies on a page that is not HTML");
        }
        String domain = this.getDomainForCookie();
        this.verifyDomain(cookie, domain);
        this.getWebClient().getCookieManager().addCookie(new com.gargoylesoftware.htmlunit.util.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure()));
    }

    private void verifyDomain(Cookie cookie, String expectedDomain) {
        String domain = cookie.getDomain();
        if (domain == null) {
            return;
        }
        if ("".equals(domain)) {
            throw new InvalidCookieDomainException("Domain must not be an empty string. Consider using null instead");
        }
        if (domain.matches(".*[^:]:\\d+$")) {
            domain = domain.replaceFirst(":\\d+$", "");
        }
        expectedDomain = expectedDomain.startsWith(".") ? expectedDomain : "." + expectedDomain;
        String string = domain = domain.startsWith(".") ? domain : "." + domain;
        if (!expectedDomain.endsWith(domain)) {
            throw new InvalidCookieDomainException(String.format("You may only add cookies that would be visible to the current domain: %s => %s", domain, expectedDomain));
        }
    }

    public Cookie getCookieNamed(String name) {
        Set<Cookie> allCookies = this.getCookies();
        for (Cookie cookie : allCookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public void deleteCookieNamed(String name) {
        CookieManager cookieManager = this.getWebClient().getCookieManager();
        URL url = this.getRawUrl();
        Set rawCookies = this.getWebClient().getCookies(url);
        for (com.gargoylesoftware.htmlunit.util.Cookie cookie : rawCookies) {
            if (!name.equals(cookie.getName())) continue;
            cookieManager.removeCookie(cookie);
        }
    }

    public void deleteCookie(Cookie cookie) {
        this.getWebClient().getCookieManager().removeCookie(this.convertSeleniumCookieToHtmlUnit(cookie));
    }

    public void deleteAllCookies() {
        CookieManager cookieManager = this.getWebClient().getCookieManager();
        URL url = this.getRawUrl();
        Set rawCookies = this.getWebClient().getCookies(url);
        for (com.gargoylesoftware.htmlunit.util.Cookie cookie : rawCookies) {
            cookieManager.removeCookie(cookie);
        }
    }

    public Set<Cookie> getCookies() {
        URL url = this.getRawUrl();
        if (!url.toString().startsWith("http")) {
            return Sets.newHashSet();
        }
        return ImmutableSet.copyOf((Collection)Collections2.transform((Collection)this.getWebClient().getCookies(url), this.htmlUnitCookieToSeleniumCookieTransformer::apply));
    }

    private com.gargoylesoftware.htmlunit.util.Cookie convertSeleniumCookieToHtmlUnit(Cookie cookie) {
        return new com.gargoylesoftware.htmlunit.util.Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure(), cookie.isHttpOnly());
    }

    private String getDomainForCookie() {
        URL current = this.getRawUrl();
        return current.getHost();
    }

    private WebClient getWebClient() {
        return this.driver.getWebClient();
    }

    public WebDriver.Timeouts timeouts() {
        return this.timeouts;
    }

    public WebDriver.ImeHandler ime() {
        throw new UnsupportedOperationException("Cannot input IME using HtmlUnit.");
    }

    public WebDriver.Window window() {
        return this.window;
    }

    private URL getRawUrl() {
        return Optional.ofNullable(this.window.lastPage()).map(Page::getUrl).orElse(null);
    }
}

