/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v118.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SubresourceWebBundleInnerResponseParsed {
    private final RequestId innerRequestId;
    private final String innerRequestURL;
    private final Optional<RequestId> bundleRequestId;

    public SubresourceWebBundleInnerResponseParsed(RequestId innerRequestId, String innerRequestURL, Optional<RequestId> bundleRequestId) {
        this.innerRequestId = Objects.requireNonNull(innerRequestId, "innerRequestId is required");
        this.innerRequestURL = Objects.requireNonNull(innerRequestURL, "innerRequestURL is required");
        this.bundleRequestId = bundleRequestId;
    }

    public RequestId getInnerRequestId() {
        return this.innerRequestId;
    }

    public String getInnerRequestURL() {
        return this.innerRequestURL;
    }

    public Optional<RequestId> getBundleRequestId() {
        return this.bundleRequestId;
    }

    private static SubresourceWebBundleInnerResponseParsed fromJson(JsonInput input) {
        RequestId innerRequestId = null;
        String innerRequestURL = null;
        Optional<RequestId> bundleRequestId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "innerRequestId": {
                    innerRequestId = (RequestId)input.read(RequestId.class);
                    continue block10;
                }
                case "innerRequestURL": {
                    innerRequestURL = input.nextString();
                    continue block10;
                }
                case "bundleRequestId": {
                    bundleRequestId = Optional.ofNullable((RequestId)input.read(RequestId.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SubresourceWebBundleInnerResponseParsed(innerRequestId, innerRequestURL, bundleRequestId);
    }
}

