/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.downloadcache;

import java.nio.file.Path;

public class HashMismatchException
extends Exception {
    private final String expectedFileHash;
    private final String downloadedFileHash;
    private final Path downloadedFile;

    public HashMismatchException(String expectedFileHash, String downloadedFileHash, Path downloadedFile) {
        super("Hash mismatch for file " + String.valueOf(downloadedFile) + ". Expected hash: " + expectedFileHash + ", actual hash: " + downloadedFileHash);
        this.expectedFileHash = expectedFileHash;
        this.downloadedFileHash = downloadedFileHash;
        this.downloadedFile = downloadedFile;
    }

    public String getExpectedFileHash() {
        return this.expectedFileHash;
    }

    public Path getDownloadedFile() {
        return this.downloadedFile;
    }

    public String getDownloadedFileHash() {
        return this.downloadedFileHash;
    }
}

