/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.http.HttpConfig;
import org.sonarsource.scanner.lib.internal.http.HttpException;
import org.sonarsource.scanner.lib.internal.http.OkHttpClientFactory;
import org.sonarsource.scanner.lib.internal.util.Utils;

public class ScannerHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerHttpClient.class);
    private static final String EXCEPTION_MESSAGE_MISSING_SLASH = "URL path must start with slash: %s";
    private OkHttpClient sharedHttpClient;
    private HttpConfig httpConfig;

    public void init(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.sharedHttpClient = OkHttpClientFactory.create(httpConfig);
    }

    public void downloadFromRestApi(String urlPath, Path toFile) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getRestApiBaseUrl() + urlPath;
        this.downloadFile(url, toFile, true);
    }

    public void downloadFromWebApi(String urlPath, Path toFile) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getWebApiBaseUrl() + urlPath;
        this.downloadFile(url, toFile, true);
    }

    public void downloadFromExternalUrl(String url, Path toFile) {
        this.downloadFile(url, toFile, false);
    }

    private void downloadFile(String url, Path toFile, boolean authentication) {
        LOG.debug("Download {} to {}", (Object)url, (Object)toFile.toAbsolutePath());
        this.callUrl(url, authentication, "application/octet-stream", responseBody -> {
            Object var3_4;
            block8: {
                InputStream in = responseBody.byteStream();
                try {
                    Files.copy(in, toFile, StandardCopyOption.REPLACE_EXISTING);
                    var3_4 = null;
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | RuntimeException e) {
                        Utils.deleteQuietly(toFile);
                        throw e;
                    }
                }
                in.close();
            }
            return var3_4;
        });
    }

    public String callRestApi(String urlPath) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getRestApiBaseUrl() + urlPath;
        return this.callApi(url);
    }

    public String callWebApi(String urlPath) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getWebApiBaseUrl() + urlPath;
        return this.callApi(url);
    }

    private String callApi(String url) {
        return this.callUrl(url, true, null, ResponseBody::string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <G> G callUrl(String url, boolean authentication, @Nullable String acceptHeader, ResponseHandler<G> responseHandler) {
        OkHttpClient httpClient = this.buildHttpClient(authentication);
        Request request = this.prepareRequest(url, acceptHeader);
        try (Response response = httpClient.newCall(request).execute();){
            ResponseBody body = response.body();
            if (!response.isSuccessful()) {
                String string;
                URL uRL = response.request().url().url();
                int n = response.code();
                String string2 = response.message();
                if (body != null) {
                    string = body.string();
                    throw new HttpException(uRL, n, string2, string);
                }
                string = null;
                throw new HttpException(uRL, n, string2, string);
            }
            G g = responseHandler.apply(Objects.requireNonNull(body, "Response body is empty"));
            return g;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Call to URL [%s] failed: %s", url, e.getMessage()), e);
        }
    }

    private Request prepareRequest(String url, @Nullable String acceptHeader) {
        Request.Builder requestBuilder = new Request.Builder().get().url(url).addHeader("User-Agent", this.httpConfig.getUserAgent());
        if (acceptHeader != null) {
            requestBuilder.header("Accept", acceptHeader);
        }
        return requestBuilder.build();
    }

    private OkHttpClient buildHttpClient(boolean authentication) {
        if (authentication) {
            return this.sharedHttpClient.newBuilder().addNetworkInterceptor(chain -> {
                Request request = chain.request();
                if (this.httpConfig.getToken() != null) {
                    request = request.newBuilder().header("Authorization", "Bearer " + this.httpConfig.getToken()).build();
                } else if (this.httpConfig.getLogin() != null) {
                    request = request.newBuilder().header("Authorization", Credentials.basic((String)this.httpConfig.getLogin(), (String)(this.httpConfig.getPassword() != null ? this.httpConfig.getPassword() : ""))).build();
                }
                return chain.proceed(request);
            }).build();
        }
        return this.sharedHttpClient;
    }

    private static interface ResponseHandler<G> {
        public G apply(ResponseBody var1) throws IOException;
    }
}

