/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;

public class DefaultTextRange
implements TextRange {
    private final TextPointer start;
    private final TextPointer end;

    public DefaultTextRange(TextPointer start, TextPointer end) {
        this.start = start;
        this.end = end;
    }

    public TextPointer start() {
        return this.start;
    }

    public TextPointer end() {
        return this.end;
    }

    public boolean overlap(TextRange another) {
        return this.end.compareTo((Object)another.start()) > 0 && another.end().compareTo((Object)this.start) > 0;
    }

    public String toString() {
        return "Range[from " + this.start + " to " + this.end + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultTextRange other = (DefaultTextRange)obj;
        return this.start.equals(other.start) && this.end.equals(other.end);
    }

    public int hashCode() {
        return this.start.hashCode() * 17 + this.end.hashCode();
    }
}

