/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config.internal;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.internal.AesCipher;

final class AesGCMCipher
extends AesCipher {
    private static final int GCM_TAG_LENGTH_IN_BITS = 128;
    private static final int GCM_IV_LENGTH_IN_BYTES = 12;
    private static final String CRYPTO_ALGO = "AES/GCM/NoPadding";

    AesGCMCipher(@Nullable String pathToSecretKey) {
        super(pathToSecretKey);
    }

    @Override
    public String encrypt(String clearText) {
        try {
            Cipher cipher = Cipher.getInstance(CRYPTO_ALGO);
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            cipher.init(1, this.loadSecretFile(), new GCMParameterSpec(128, iv));
            byte[] encryptedText = cipher.doFinal(clearText.getBytes(StandardCharsets.UTF_8.name()));
            return Base64.encodeBase64String((byte[])ByteBuffer.allocate(12 + encryptedText.length).put(iv).put(encryptedText).array());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String decrypt(String encryptedText) {
        try {
            Cipher cipher = Cipher.getInstance(CRYPTO_ALGO);
            ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.decodeBase64((String)StringUtils.trim((String)encryptedText)));
            byte[] iv = new byte[12];
            byteBuffer.get(iv);
            byte[] cipherText = new byte[byteBuffer.remaining()];
            byteBuffer.get(cipherText);
            cipher.init(2, this.loadSecretFile(), new GCMParameterSpec(128, iv));
            byte[] cipherData = cipher.doFinal(cipherText);
            return new String(cipherData, StandardCharsets.UTF_8);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

