/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.impl.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ScannerUtils {
    private ScannerUtils() {
    }

    public static String cleanKeyForFilename(String projectKey) {
        String cleanKey = StringUtils.deleteWhitespace((String)projectKey);
        return StringUtils.replace((String)cleanKey, (String)":", (String)"_");
    }

    public static String encodeForUrl(@Nullable String url) {
        try {
            return URLEncoder.encode(url == null ? "" : url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding not supported", e);
        }
    }

    public static String describe(Object o) {
        try {
            String str;
            if (o.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class && (str = o.toString()) != null) {
                return str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o.getClass().getName();
    }

    public static String pluralize(String str, int i) {
        if (i == 1) {
            return str;
        }
        return str + "s";
    }
}

