/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@Immutable
public class ExceptionCauseMatcher
extends TypeSafeMatcher<Throwable> {
    private static final String EXPECT_NO_MESSAGE_CONSTANT = "RQXG8QTUCXOT7HZ3APPKBKUE5";
    private final Class<? extends Throwable> type;
    @CheckForNull
    private final String expectedMessage;

    private ExceptionCauseMatcher(Class<? extends Throwable> type, @Nullable String expectedMessage) {
        this.type = type;
        this.expectedMessage = expectedMessage;
    }

    public static ExceptionCauseMatcher hasType(Class<? extends Throwable> type) {
        return new ExceptionCauseMatcher(type, null);
    }

    public ExceptionCauseMatcher andMessage(String expectedMessage) {
        return new ExceptionCauseMatcher(this.type, Objects.requireNonNull(expectedMessage));
    }

    public ExceptionCauseMatcher andNoMessage() {
        return new ExceptionCauseMatcher(this.type, EXPECT_NO_MESSAGE_CONSTANT);
    }

    protected boolean matchesSafely(Throwable item) {
        if (!item.getClass().isAssignableFrom(this.type)) {
            return false;
        }
        if (this.expectedMessage == null) {
            return true;
        }
        if (EXPECT_NO_MESSAGE_CONSTANT.equals(this.expectedMessage)) {
            return item.getMessage() == null;
        }
        return item.getMessage().contains(this.expectedMessage);
    }

    public void describeTo(Description description) {
        description.appendText("of type ").appendValue(this.type);
        if (EXPECT_NO_MESSAGE_CONSTANT.equals(this.expectedMessage)) {
            description.appendText(" and no message");
        } else if (this.expectedMessage != null) {
            description.appendText(" and message ").appendValue((Object)this.expectedMessage);
        }
        description.appendText(" but");
    }
}

